/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.util.ban.Ban;
import org.spongepowered.api.util.ban.BanType;
import org.spongepowered.api.util.ban.BanTypes;
import org.spongepowered.common.ban.SpongeBanType;

public class BanTypeRegistryModule
implements CatalogRegistryModule<BanType> {
    @RegisterCatalog(value=BanTypes.class)
    public final BiMap<String, BanType> banTypeMappings = HashBiMap.create();

    @Override
    public Optional<BanType> getById(String id) {
        return Optional.ofNullable(this.banTypeMappings.get(Preconditions.checkNotNull(id, "id").toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<BanType> getAll() {
        return ImmutableList.copyOf(this.banTypeMappings.values());
    }

    @Override
    public void registerDefaults() {
        this.banTypeMappings.put("profile", new SpongeBanType(0, "PROFILE", Ban.Profile.class));
        this.banTypeMappings.put("ip", new SpongeBanType(1, "IP", Ban.Ip.class));
    }
}

