/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.trait.BlockTrait;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.common.registry.type.BlockTypeRegistryModule;

public final class BlockStateRegistryModule
implements CatalogRegistryModule<BlockState> {
    private final Map<String, BlockState> blockStateMap = new LinkedHashMap<String, BlockState>();

    public static BlockStateRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public Optional<BlockState> getById(String id) {
        String state = Preconditions.checkNotNull(id, "Id cannot be null!").toLowerCase(Locale.ENGLISH);
        BlockState potential = this.blockStateMap.get(state);
        if (potential != null) {
            return Optional.of(potential);
        }
        if (state.contains("[")) {
            String[] split = state.split("\\[");
            Optional<BlockType> blockType = BlockTypeRegistryModule.getInstance().getById(split[0]);
            if (!blockType.isPresent()) {
                return Optional.empty();
            }
            BlockType type = blockType.get();
            Collection<BlockTrait<?>> traits = type.getTraits();
            String properties = split[1].replace("[", "").replace("]", "");
            if (properties.isEmpty()) {
                throw new IllegalArgumentException("The properties cannot be specified and empty (omit [] if there are no properties)");
            }
            String[] propertyValuePairs = properties.split(",");
            ArrayList foundPairs = new ArrayList(propertyValuePairs.length);
            for (String propertyValuePair : propertyValuePairs) {
                String[] pair = propertyValuePair.split("=");
                if (pair.length == 1) {
                    throw new IllegalArgumentException("The properties list is malformed in \"" + id + "\" (all properties must be key=value pairs)");
                }
                type.getTrait(pair[0]).ifPresent(trait -> trait.parseValue(pair[1]).ifPresent(propertyValue -> foundPairs.add(Tuple.of(trait, propertyValue))));
            }
            BlockState.MatcherBuilder matcher = BlockState.matcher(type);
            for (Tuple foundPair : foundPairs) {
                matcher.trait((BlockTrait)foundPair.getFirst(), (Comparable)foundPair.getSecond());
            }
            BlockState.StateMatcher build = matcher.build();
            return type.getAllBlockStates().stream().filter(build::matches).findFirst();
        }
        return BlockTypeRegistryModule.getInstance().getById(state).map(BlockType::getDefaultState);
    }

    @Override
    public Collection<BlockState> getAll() {
        return ImmutableList.copyOf(this.blockStateMap.values());
    }

    void registerBlockState(BlockState blockState) {
        Preconditions.checkNotNull(blockState, "BlockState cannot be null!");
        if (!this.blockStateMap.containsKey(blockState.getId().toLowerCase(Locale.ENGLISH))) {
            this.blockStateMap.put(blockState.getId().toLowerCase(Locale.ENGLISH), blockState);
        }
    }

    BlockStateRegistryModule() {
    }

    private static final class Holder {
        static final BlockStateRegistryModule INSTANCE = new BlockStateRegistryModule();

        private Holder() {
        }
    }
}

