/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.data.type.NotePitch;
import org.spongepowered.api.data.type.NotePitches;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.data.type.SpongeNotePitch;

public final class NotePitchRegistryModule
implements CatalogRegistryModule<NotePitch> {
    private static final Map<Byte, SpongeNotePitch> pitchMappings = ImmutableMap.builder().put((byte)0, new SpongeNotePitch(0, "F_SHARP0")).put((byte)1, new SpongeNotePitch(1, "G0")).put((byte)2, new SpongeNotePitch(2, "G_SHARP0")).put((byte)3, new SpongeNotePitch(3, "A1")).put((byte)4, new SpongeNotePitch(4, "A_SHARP1")).put((byte)5, new SpongeNotePitch(5, "B1")).put((byte)6, new SpongeNotePitch(6, "C1")).put((byte)7, new SpongeNotePitch(7, "C_SHARP1")).put((byte)8, new SpongeNotePitch(8, "D1")).put((byte)9, new SpongeNotePitch(9, "D_SHARP1")).put((byte)10, new SpongeNotePitch(10, "E1")).put((byte)11, new SpongeNotePitch(11, "F1")).put((byte)12, new SpongeNotePitch(12, "F_SHARP1")).put((byte)13, new SpongeNotePitch(13, "G1")).put((byte)14, new SpongeNotePitch(14, "G_SHARP1")).put((byte)15, new SpongeNotePitch(15, "A2")).put((byte)16, new SpongeNotePitch(16, "A_SHARP2")).put((byte)17, new SpongeNotePitch(17, "B2")).put((byte)18, new SpongeNotePitch(18, "C2")).put((byte)19, new SpongeNotePitch(19, "C_SHARP2")).put((byte)20, new SpongeNotePitch(20, "D2")).put((byte)21, new SpongeNotePitch(21, "D_SHARP2")).put((byte)22, new SpongeNotePitch(22, "E2")).put((byte)23, new SpongeNotePitch(23, "F2")).put((byte)24, new SpongeNotePitch(24, "F_SHARP2")).build();
    @RegisterCatalog(value=NotePitches.class)
    private final Map<String, NotePitch> notePitchMap = new HashMap<String, NotePitch>();

    public static NotePitch getPitch(byte note) {
        note = (byte)(note % 25);
        return pitchMappings.get(note);
    }

    @Override
    public Optional<NotePitch> getById(String id) {
        return Optional.ofNullable(this.notePitchMap.get(Preconditions.checkNotNull(id).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<NotePitch> getAll() {
        return ImmutableList.copyOf(this.notePitchMap.values());
    }

    @Override
    public void registerDefaults() {
        for (SpongeNotePitch pitch : pitchMappings.values()) {
            this.notePitchMap.put(pitch.getId().toLowerCase(Locale.ENGLISH), pitch);
        }
    }
}

