/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.block;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.trait.IntegerTrait;
import org.spongepowered.api.block.trait.IntegerTraits;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;
import org.spongepowered.common.registry.type.AbstractPrefixCheckCatalogRegistryModule;

@RegisterCatalog(value=IntegerTraits.class)
public final class IntegerTraitRegistryModule
extends AbstractPrefixCheckCatalogRegistryModule<IntegerTrait>
implements SpongeAdditionalCatalogRegistryModule<IntegerTrait>,
AlternateCatalogRegistryModule<IntegerTrait> {
    public static IntegerTraitRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public boolean allowsApiRegistration() {
        return false;
    }

    @Override
    public void registerAdditionalCatalog(IntegerTrait extraCatalog) {
        this.catalogTypeMap.put(extraCatalog.getId().toLowerCase(Locale.ENGLISH), extraCatalog);
    }

    public void registerBlock(String id, BlockType block, IntegerTrait property) {
        Preconditions.checkNotNull(id, "Id was null!");
        this.catalogTypeMap.put(id.toLowerCase(Locale.ENGLISH), property);
        String propertyId = block.getId().toLowerCase(Locale.ENGLISH) + "_" + property.getName().toLowerCase(Locale.ENGLISH);
        this.catalogTypeMap.put(propertyId, property);
    }

    IntegerTraitRegistryModule() {
        super("minecraft");
    }

    @Override
    public Map<String, IntegerTrait> provideCatalogMap() {
        HashMap<String, IntegerTrait> map = new HashMap<String, IntegerTrait>();
        for (Map.Entry enumTraitEntry : this.catalogTypeMap.entrySet()) {
            map.put(((String)enumTraitEntry.getKey()).replace("minecraft:", ""), (IntegerTrait)enumTraitEntry.getValue());
        }
        return map;
    }

    private static final class Holder {
        static final IntegerTraitRegistryModule INSTANCE = new IntegerTraitRegistryModule();

        private Holder() {
        }
    }
}

