/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.boss;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.BossInfo;
import org.spongepowered.api.boss.BossBarOverlay;
import org.spongepowered.api.boss.BossBarOverlays;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.AdditionalRegistration;
import org.spongepowered.api.registry.util.RegisterCatalog;

public final class BossBarOverlayRegistryModule
implements CatalogRegistryModule<BossBarOverlay> {
    @RegisterCatalog(value=BossBarOverlays.class)
    public final Map<String, BossBarOverlay> overlayMap = Maps.newHashMap();

    @Override
    public void registerDefaults() {
        this.overlayMap.put("progress", (BossBarOverlay)BossInfo.Overlay.PROGRESS);
        this.overlayMap.put("notched_6", (BossBarOverlay)BossInfo.Overlay.NOTCHED_6);
        this.overlayMap.put("notched_10", (BossBarOverlay)BossInfo.Overlay.NOTCHED_10);
        this.overlayMap.put("notched_12", (BossBarOverlay)BossInfo.Overlay.NOTCHED_12);
        this.overlayMap.put("notched_20", (BossBarOverlay)BossInfo.Overlay.NOTCHED_20);
    }

    @Override
    public Optional<BossBarOverlay> getById(String id) {
        return Optional.ofNullable(this.overlayMap.get(Preconditions.checkNotNull(id, "id").toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<BossBarOverlay> getAll() {
        return ImmutableSet.copyOf(this.overlayMap.values());
    }

    @AdditionalRegistration
    public void customRegistration() {
        for (BossInfo.Overlay overlay : BossInfo.Overlay.values()) {
            String name = overlay.name().toLowerCase(Locale.ENGLISH);
            if (this.overlayMap.containsKey(name)) continue;
            this.overlayMap.put(name, (BossBarOverlay)overlay);
        }
    }
}

