/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.data.persistence.DataFormat;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.registry.AdditionalCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.data.persistence.HoconDataFormat;
import org.spongepowered.common.data.persistence.JsonDataFormat;
import org.spongepowered.common.data.persistence.NbtDataFormat;

public class DataFormatRegistryModule
implements AdditionalCatalogRegistryModule<DataFormat> {
    @RegisterCatalog(value=DataFormats.class)
    private final Map<String, DataFormat> dataFormatMappings = new HashMap<String, DataFormat>();

    @Override
    public Optional<DataFormat> getById(String id) {
        return Optional.ofNullable(this.dataFormatMappings.get(Preconditions.checkNotNull(id).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<DataFormat> getAll() {
        return ImmutableList.copyOf(this.dataFormatMappings.values());
    }

    @Override
    public void registerAdditionalCatalog(DataFormat extraCatalog) {
        Preconditions.checkNotNull(extraCatalog, "CatalogType cannot be null");
        Preconditions.checkArgument(!extraCatalog.getId().isEmpty(), "Id cannot be empty");
        Preconditions.checkArgument(!this.dataFormatMappings.containsKey(extraCatalog.getId()), "Duplicate Id");
        this.dataFormatMappings.put(extraCatalog.getId(), extraCatalog);
    }

    @Override
    public void registerDefaults() {
        this.dataFormatMappings.put("nbt", new NbtDataFormat("nbt"));
        this.dataFormatMappings.put("json", new JsonDataFormat());
        this.dataFormatMappings.put("hocon", new HoconDataFormat("hocon"));
    }
}

