/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.EnumHandSide;
import org.spongepowered.api.data.type.HandPreference;
import org.spongepowered.api.data.type.HandPreferences;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;

public class HandPreferenceRegistryModule
implements CatalogRegistryModule<HandPreference> {
    @RegisterCatalog(value=HandPreferences.class)
    public final Map<String, HandPreference> handSideMap = Maps.newHashMap();

    public static HandPreferenceRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public void registerDefaults() {
        this.handSideMap.put("left", (HandPreference)EnumHandSide.LEFT);
        this.handSideMap.put("right", (HandPreference)EnumHandSide.RIGHT);
    }

    @Override
    public Optional<HandPreference> getById(String id) {
        return Optional.ofNullable(this.handSideMap.get(Preconditions.checkNotNull(id, "id").toLowerCase()));
    }

    @Override
    public Collection<HandPreference> getAll() {
        return ImmutableSet.copyOf(this.handSideMap.values());
    }

    HandPreferenceRegistryModule() {
    }

    static final class Holder {
        static final HandPreferenceRegistryModule INSTANCE = new HandPreferenceRegistryModule();

        Holder() {
        }
    }
}

