/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.effect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemRecord;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import org.spongepowered.api.effect.sound.SoundType;
import org.spongepowered.api.effect.sound.record.RecordType;
import org.spongepowered.api.effect.sound.record.RecordTypes;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.CustomCatalogRegistration;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.registry.util.RegistrationDependency;
import org.spongepowered.common.effect.record.SpongeRecordType;
import org.spongepowered.common.mixin.core.item.ItemRecordAccessor;
import org.spongepowered.common.registry.RegistryHelper;
import org.spongepowered.common.registry.type.ItemTypeRegistryModule;
import org.spongepowered.common.registry.type.effect.SoundRegistryModule;

@RegistrationDependency(value={SoundRegistryModule.class, ItemTypeRegistryModule.class})
public final class RecordTypeRegistryModule
implements CatalogRegistryModule<RecordType> {
    @RegisterCatalog(value=RecordTypes.class)
    private final Map<String, RecordType> mappings = new HashMap<String, RecordType>();

    public static RecordTypeRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    private RecordTypeRegistryModule() {
    }

    public Optional<RecordType> getByItem(Item itemType) {
        ResourceLocation resourceLocation = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)itemType);
        if (resourceLocation == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.mappings.get(resourceLocation.toString()));
    }

    @Override
    public Optional<RecordType> getById(String id) {
        Preconditions.checkNotNull(id);
        if (!id.contains(":")) {
            id = "minecraft:" + id;
        }
        return Optional.ofNullable(this.mappings.get(Preconditions.checkNotNull(id).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<RecordType> getAll() {
        return ImmutableList.copyOf(this.mappings.values());
    }

    private void add(SpongeRecordType recordType) {
        String id = recordType.getId();
        this.mappings.put(id, recordType);
    }

    @CustomCatalogRegistration
    public void customRegistration() {
        for (Map.Entry<SoundEvent, ItemRecord> recordEntry : ((ItemRecordAccessor)Items.field_151093_ce).accessor$getRecords().entrySet()) {
            ItemRecord recordItem = recordEntry.getValue();
            String key = ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)recordItem)).toString();
            if (this.mappings.containsKey(key)) continue;
            this.add(new SpongeRecordType(key, recordItem.func_77658_a(), (ItemType)recordItem, (SoundType)((ItemRecordAccessor)recordItem).accessor$getSoundEvent()));
        }
        RegistryHelper.mapFields(RecordTypes.class, fieldName -> {
            String name = fieldName.toLowerCase(Locale.ENGLISH);
            if (name.equals("thirteen")) {
                return this.mappings.get("minecraft:record_13");
            }
            if (name.equals("eleven")) {
                return this.mappings.get("minecraft:record_11");
            }
            RecordType recordType = this.mappings.get("minecraft:record_" + name);
            return recordType;
        });
    }

    private static final class Holder {
        static final RecordTypeRegistryModule INSTANCE = new RecordTypeRegistryModule();

        private Holder() {
        }
    }
}

