/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.effect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.effect.sound.SoundCategories;
import org.spongepowered.api.effect.sound.SoundCategory;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;

public final class SoundCategoryRegistryModule
implements AlternateCatalogRegistryModule<SoundCategory> {
    @RegisterCatalog(value=SoundCategories.class)
    private final Map<String, SoundCategory> soundCategoryMap = new HashMap<String, SoundCategory>();

    @Override
    public Map<String, SoundCategory> provideCatalogMap() {
        HashMap<String, SoundCategory> soundCategoryMap = new HashMap<String, SoundCategory>();
        for (Map.Entry<String, SoundCategory> entry : this.soundCategoryMap.entrySet()) {
            soundCategoryMap.put(entry.getKey().replace("minecraft:", ""), entry.getValue());
        }
        return soundCategoryMap;
    }

    @Override
    public Optional<SoundCategory> getById(String id) {
        return Optional.ofNullable(this.soundCategoryMap.get(Preconditions.checkNotNull(id).toLowerCase()));
    }

    @Override
    public Collection<SoundCategory> getAll() {
        return ImmutableList.copyOf(this.soundCategoryMap.values());
    }

    @Override
    public void registerDefaults() {
        this.soundCategoryMap.put("minecraft:master", (SoundCategory)net.minecraft.util.SoundCategory.MASTER);
        this.soundCategoryMap.put("minecraft:music", (SoundCategory)net.minecraft.util.SoundCategory.MUSIC);
        this.soundCategoryMap.put("minecraft:record", (SoundCategory)net.minecraft.util.SoundCategory.RECORDS);
        this.soundCategoryMap.put("minecraft:weather", (SoundCategory)net.minecraft.util.SoundCategory.WEATHER);
        this.soundCategoryMap.put("minecraft:block", (SoundCategory)net.minecraft.util.SoundCategory.BLOCKS);
        this.soundCategoryMap.put("minecraft:hostile", (SoundCategory)net.minecraft.util.SoundCategory.HOSTILE);
        this.soundCategoryMap.put("minecraft:neutral", (SoundCategory)net.minecraft.util.SoundCategory.NEUTRAL);
        this.soundCategoryMap.put("minecraft:player", (SoundCategory)net.minecraft.util.SoundCategory.PLAYERS);
        this.soundCategoryMap.put("minecraft:ambient", (SoundCategory)net.minecraft.util.SoundCategory.AMBIENT);
        this.soundCategoryMap.put("minecraft:voice", (SoundCategory)net.minecraft.util.SoundCategory.VOICE);
    }
}

