/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.data.type.BodyPart;
import org.spongepowered.api.data.type.BodyParts;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.data.type.SpongeBodyPart;

public class BodyPartRegistryModule
implements CatalogRegistryModule<BodyPart> {
    @RegisterCatalog(value=BodyParts.class)
    private final Map<String, BodyPart> bodyPartMap = new HashMap<String, BodyPart>();

    @Override
    public Optional<BodyPart> getById(String id) {
        return Optional.ofNullable(this.bodyPartMap.get(Preconditions.checkNotNull(id).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<BodyPart> getAll() {
        return ImmutableSet.copyOf(this.bodyPartMap.values());
    }

    @Override
    public void registerDefaults() {
        this.bodyPartMap.put("head", new SpongeBodyPart("HEAD"));
        this.bodyPartMap.put("chest", new SpongeBodyPart("CHEST"));
        this.bodyPartMap.put("left_arm", new SpongeBodyPart("LEFT_ARM"));
        this.bodyPartMap.put("right_arm", new SpongeBodyPart("RIGHT_ARM"));
        this.bodyPartMap.put("left_leg", new SpongeBodyPart("LEFT_LEG"));
        this.bodyPartMap.put("right_leg", new SpongeBodyPart("RIGHT_LEG"));
    }
}

