/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.data.type.Career;
import org.spongepowered.api.data.type.Careers;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.registry.util.RegistrationDependency;
import org.spongepowered.common.entity.SpongeCareer;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;
import org.spongepowered.common.registry.type.entity.ProfessionRegistryModule;
import org.spongepowered.common.text.translation.SpongeTranslation;

@RegistrationDependency(value={ProfessionRegistryModule.class})
public class CareerRegistryModule
implements SpongeAdditionalCatalogRegistryModule<Career> {
    public final SpongeCareer LEATHERWORKER = new SpongeCareer(1, "minecraft:leatherworker", ProfessionRegistryModule.BUTCHER, new SpongeTranslation("entity.Villager.leather"));
    public final SpongeCareer BUTCHER = new SpongeCareer(0, "minecraft:butcher", ProfessionRegistryModule.BUTCHER, new SpongeTranslation("entity.Villager.butcher"));
    public final SpongeCareer TOOL_SMITH = new SpongeCareer(2, "minecraft:tool_smith", ProfessionRegistryModule.BLACKSMITH, new SpongeTranslation("entity.Villager.tool"));
    public final SpongeCareer WEAPON_SMITH = new SpongeCareer(1, "minecraft:weapon_smith", ProfessionRegistryModule.BLACKSMITH, new SpongeTranslation("entity.Villager.weapon"));
    public final SpongeCareer ARMORER = new SpongeCareer(0, "minecraft:armorer", ProfessionRegistryModule.BLACKSMITH, new SpongeTranslation("entity.Villager.armor"));
    public final SpongeCareer CLERIC = new SpongeCareer(0, "minecraft:cleric", ProfessionRegistryModule.PRIEST, new SpongeTranslation("entity.Villager.cleric"));
    public final SpongeCareer CARTOGRAPHER = new SpongeCareer(1, "minecraft:cartographer", ProfessionRegistryModule.LIBRARIAN, new SpongeTranslation("entity.Villager.cartographer"));
    public final SpongeCareer LIBRARIAN = new SpongeCareer(0, "minecraft:librarian", ProfessionRegistryModule.LIBRARIAN, new SpongeTranslation("entity.Villager.librarian"));
    public final SpongeCareer FLETCHER = new SpongeCareer(3, "minecraft:fletcher", ProfessionRegistryModule.FARMER, new SpongeTranslation("entity.Villager.fletcher"));
    public final SpongeCareer SHEPHERD = new SpongeCareer(2, "minecraft:shepherd", ProfessionRegistryModule.FARMER, new SpongeTranslation("entity.Villager.shepherd"));
    public final SpongeCareer FISHERMAN = new SpongeCareer(1, "minecraft:fisherman", ProfessionRegistryModule.FARMER, new SpongeTranslation("entity.Villager.fisherman"));
    public final SpongeCareer FARMER = new SpongeCareer(0, "minecraft:farmer", ProfessionRegistryModule.FARMER, new SpongeTranslation("entity.Villager.farmer"));
    public final SpongeCareer NITWIT = new SpongeCareer(0, "minecraft:nitwit", ProfessionRegistryModule.NITWIT, new SpongeTranslation("entity.Villager.nitwit"));
    public static final Comparator<SpongeCareer> CAREER_COMPARATOR = Comparator.comparingInt(o -> o.type);
    @RegisterCatalog(value=Careers.class)
    private final Map<String, Career> careerMap = new HashMap<String, Career>();
    private final Map<String, String> forgeSpongeMapping = ImmutableMap.builder().put("leather", "leatherworker").put("armor", "armorer").put("tool", "tool_smith").put("weapon", "weapon_smith").build();

    public static CareerRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public boolean allowsApiRegistration() {
        return false;
    }

    @Override
    public void registerAdditionalCatalog(Career extraCatalog) {
        if (this.forgeSpongeMapping.containsKey(extraCatalog.getId().toLowerCase(Locale.ENGLISH))) {
            return;
        }
        if (!this.careerMap.containsKey(extraCatalog.getId())) {
            this.careerMap.put(extraCatalog.getId().toLowerCase(Locale.ENGLISH), extraCatalog);
        }
        ProfessionRegistryModule.getInstance().registerCareerForProfession(extraCatalog);
    }

    @Override
    public Optional<Career> getById(String id) {
        if (!id.contains(":")) {
            id = "minecraft:" + id;
        }
        return Optional.ofNullable(this.careerMap.get(Preconditions.checkNotNull(id).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<Career> getAll() {
        return ImmutableList.copyOf(this.careerMap.values());
    }

    public Career registerCareer(Career career) {
        this.registerAdditionalCatalog(career);
        return career;
    }

    @Override
    public void registerDefaults() {
        this.careerMap.put("farmer", this.registerCareer(this.FARMER));
        this.careerMap.put("fisherman", this.registerCareer(this.FISHERMAN));
        this.careerMap.put("shepherd", this.registerCareer(this.SHEPHERD));
        this.careerMap.put("fletcher", this.registerCareer(this.FLETCHER));
        this.careerMap.put("librarian", this.registerCareer(this.LIBRARIAN));
        this.careerMap.put("cartographer", this.registerCareer(this.CARTOGRAPHER));
        this.careerMap.put("cleric", this.registerCareer(this.CLERIC));
        this.careerMap.put("armorer", this.registerCareer(this.ARMORER));
        this.careerMap.put("weapon_smith", this.registerCareer(this.WEAPON_SMITH));
        this.careerMap.put("tool_smith", this.registerCareer(this.TOOL_SMITH));
        this.careerMap.put("butcher", this.registerCareer(this.BUTCHER));
        this.careerMap.put("leatherworker", this.registerCareer(this.LEATHERWORKER));
        this.careerMap.put("nitwit", this.registerCareer(this.NITWIT));
    }

    CareerRegistryModule() {
    }

    private static final class Holder {
        static final CareerRegistryModule INSTANCE = new CareerRegistryModule();

        private Holder() {
        }
    }
}

