/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.projectile.EntityArrow;
import org.spongepowered.api.data.type.PickupRule;
import org.spongepowered.api.data.type.PickupRules;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.AdditionalRegistration;
import org.spongepowered.api.registry.util.RegisterCatalog;

public final class PickupRuleRegistryModule
implements CatalogRegistryModule<PickupRule> {
    @RegisterCatalog(value=PickupRules.class)
    private final Map<String, PickupRule> ruleMapping = Maps.newHashMap();

    @Override
    public Optional<PickupRule> getById(String id) {
        return Optional.ofNullable(this.ruleMapping.get(Preconditions.checkNotNull(id, "id").toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<PickupRule> getAll() {
        return ImmutableList.copyOf(this.ruleMapping.values());
    }

    @Override
    public void registerDefaults() {
        for (EntityArrow.PickupStatus status : EntityArrow.PickupStatus.values()) {
            PickupRule rule = (PickupRule)status;
            this.ruleMapping.put(rule.getId().toLowerCase(Locale.ENGLISH), rule);
        }
    }

    @AdditionalRegistration
    public void customRegistration() {
        for (EntityArrow.PickupStatus status : EntityArrow.PickupStatus.values()) {
            PickupRule rule = (PickupRule)status;
            if (this.ruleMapping.containsValue(rule)) continue;
            this.ruleMapping.put(rule.getId().toLowerCase(Locale.ENGLISH), rule);
        }
    }
}

