/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.data.type.SkinPart;
import org.spongepowered.api.data.type.SkinParts;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.data.type.SpongeSkinPart;

public final class SkinPartRegistryModule
implements AlternateCatalogRegistryModule<SkinPart> {
    private static final SkinPartRegistryModule INSTANCE = new SkinPartRegistryModule();
    @RegisterCatalog(value=SkinParts.class)
    private final ImmutableMap<String, SkinPart> skinPartMap = ImmutableMap.builder().put("minecraft:hat", this.createSkinPart(6, "hat")).put("minecraft:cape", this.createSkinPart(0, "cape")).put("minecraft:jacket", this.createSkinPart(1, "jacket")).put("minecraft:left_sleeve", this.createSkinPart(2, "left_sleeve")).put("minecraft:right_sleeve", this.createSkinPart(3, "right_sleeve")).put("minecraft:left_pants_leg", this.createSkinPart(4, "left_pants_leg")).put("minecraft:right_pants_leg", this.createSkinPart(5, "right_pants_leg")).build();

    public static SkinPartRegistryModule getInstance() {
        return INSTANCE;
    }

    private SkinPartRegistryModule() {
    }

    private SkinPart createSkinPart(int ordinal, String id) {
        return new SpongeSkinPart(ordinal, id);
    }

    @Override
    public Optional<SkinPart> getById(String id) {
        return Optional.ofNullable(this.skinPartMap.get(Preconditions.checkNotNull(id, "id").toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<SkinPart> getAll() {
        return this.skinPartMap.values();
    }

    @Override
    public Map<String, SkinPart> provideCatalogMap() {
        HashMap<String, SkinPart> map = new HashMap<String, SkinPart>();
        for (Map.Entry entry : this.skinPartMap.entrySet()) {
            map.put(((String)entry.getKey()).replace("minecraft:", ""), (SkinPart)entry.getValue());
        }
        return map;
    }
}

