/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.event;

import com.google.common.base.Preconditions;
import java.util.Locale;
import org.spongepowered.api.event.cause.entity.damage.DamageType;
import org.spongepowered.api.event.cause.entity.damage.DamageTypes;
import org.spongepowered.api.registry.AdditionalCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.event.damage.SpongeDamageType;
import org.spongepowered.common.registry.type.AbstractPrefixAlternateCatalogTypeRegistryModule;

@RegisterCatalog(value=DamageTypes.class)
public final class DamageTypeRegistryModule
extends AbstractPrefixAlternateCatalogTypeRegistryModule<DamageType>
implements AdditionalCatalogRegistryModule<DamageType> {
    public DamageTypeRegistryModule() {
        super("minecraft");
    }

    @Override
    public void registerAdditionalCatalog(DamageType extraCatalog) {
        String id = Preconditions.checkNotNull(extraCatalog).getId();
        String key = id.toLowerCase(Locale.ENGLISH);
        Preconditions.checkArgument(!key.contains("sponge:"), "Cannot register spoofed Damage Type!");
        Preconditions.checkArgument(!key.contains("minecraft:"), "Cannot register spoofed Damage Type!");
        Preconditions.checkArgument(!this.catalogTypeMap.containsKey(key), "Cannot register an already registered EventContextKey: %s", (Object)key);
        this.catalogTypeMap.put(key, extraCatalog);
    }

    @Override
    public void registerDefaults() {
        this.register(new SpongeDamageType("minecraft:attack", "attack"));
        this.register(new SpongeDamageType("minecraft:contact", "contact"));
        this.register(new SpongeDamageType("minecraft:custom", "custom"));
        this.register(new SpongeDamageType("minecraft:drown", "drown"));
        this.register(new SpongeDamageType("minecraft:explosive", "explosive"));
        this.register(new SpongeDamageType("minecraft:fall", "fall"));
        this.register(new SpongeDamageType("minecraft:fire", "fire"));
        this.register(new SpongeDamageType("minecraft:generic", "generic"));
        this.register(new SpongeDamageType("minecraft:hunger", "hunger"));
        this.register(new SpongeDamageType("minecraft:magic", "magic"));
        this.register(new SpongeDamageType("minecraft:projectile", "projectile"));
        this.register(new SpongeDamageType("minecraft:suffocate", "suffocate"));
        this.register(new SpongeDamageType("minecraft:void", "void"));
        this.register(new SpongeDamageType("minecraft:sweeping_attack", "sweeping_attack"));
        this.register(new SpongeDamageType("minecraft:magma", "magma"));
    }
}

