/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.event;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.event.cause.entity.dismount.DismountType;
import org.spongepowered.api.event.cause.entity.dismount.DismountTypes;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.data.type.SpongeDismountType;

public final class DismountTypeRegistryModule
implements CatalogRegistryModule<DismountType> {
    @RegisterCatalog(value=DismountTypes.class)
    private final Map<String, DismountType> dismountMappings = Maps.newHashMap();

    @Override
    public void registerDefaults() {
        this.dismountMappings.put("player", new SpongeDismountType("player"));
        this.dismountMappings.put("derail", new SpongeDismountType("derail"));
        this.dismountMappings.put("death", new SpongeDismountType("death"));
    }

    @Override
    public Optional<DismountType> getById(String id) {
        return Optional.ofNullable(this.dismountMappings.get(Preconditions.checkNotNull(id, "id").toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<DismountType> getAll() {
        return ImmutableSet.copyOf(this.dismountMappings.values());
    }
}

