/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.extra;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.extra.fluid.FluidType;
import org.spongepowered.api.extra.fluid.FluidTypes;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.registry.util.RegistrationDependency;
import org.spongepowered.common.data.type.SpongeCommonFluidType;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;
import org.spongepowered.common.registry.type.BlockTypeRegistryModule;

@RegistrationDependency(value={BlockTypeRegistryModule.class})
public final class FluidTypeRegistryModule
implements SpongeAdditionalCatalogRegistryModule<FluidType> {
    @RegisterCatalog(value=FluidTypes.class)
    private final Map<String, FluidType> fluidTypeMap = new HashMap<String, FluidType>();

    public static FluidTypeRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public boolean allowsApiRegistration() {
        return false;
    }

    @Override
    public void registerAdditionalCatalog(FluidType extraCatalog) {
    }

    public void registerForge(FluidType fluidType) {
        Preconditions.checkNotNull(fluidType, "Someone is registering a null FluidType!");
        this.fluidTypeMap.put(fluidType.getId(), fluidType);
    }

    @Override
    public Optional<FluidType> getById(String id) {
        return Optional.ofNullable(this.fluidTypeMap.get(Preconditions.checkNotNull(id, "FluidType id cannot be null!").toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<FluidType> getAll() {
        return ImmutableSet.copyOf(this.fluidTypeMap.values());
    }

    @Override
    public void registerDefaults() {
        if (!this.fluidTypeMap.containsKey("water")) {
            this.fluidTypeMap.put("water", new SpongeCommonFluidType("water", BlockTypes.WATER));
        }
        if (!this.fluidTypeMap.containsKey("lava")) {
            this.fluidTypeMap.put("lava", new SpongeCommonFluidType("lava", BlockTypes.LAVA));
        }
    }

    FluidTypeRegistryModule() {
    }

    private static final class Holder {
        static final FluidTypeRegistryModule INSTANCE = new FluidTypeRegistryModule();

        private Holder() {
        }
    }
}

