/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.item;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.data.type.CoalType;
import org.spongepowered.api.data.type.CoalTypes;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.item.SpongeCoalType;
import org.spongepowered.common.text.translation.SpongeTranslation;

public final class CoalTypeRegistryModule
implements CatalogRegistryModule<CoalType> {
    @RegisterCatalog(value=CoalTypes.class)
    public final Map<String, CoalType> coaltypeMappings = Maps.newHashMap();

    @Override
    public Optional<CoalType> getById(String id) {
        return Optional.ofNullable(this.coaltypeMappings.get(Preconditions.checkNotNull(id).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<CoalType> getAll() {
        return ImmutableList.copyOf(this.coaltypeMappings.values());
    }

    @Override
    public void registerDefaults() {
        this.coaltypeMappings.put("coal", new SpongeCoalType(0, "COAL", new SpongeTranslation("item.coal.name")));
        this.coaltypeMappings.put("charcoal", new SpongeCoalType(1, "CHARCOAL", new SpongeTranslation("item.charcoal.name")));
    }
}

