/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.item;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.item.ItemFishFood;
import org.spongepowered.api.data.type.CookedFish;
import org.spongepowered.api.data.type.CookedFishes;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.util.AdditionalRegistration;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.data.type.SpongeCookedFish;
import org.spongepowered.common.text.translation.SpongeTranslation;

public final class CookedFishRegistryModule
implements AlternateCatalogRegistryModule<CookedFish> {
    @RegisterCatalog(value=CookedFishes.class)
    private final Map<String, CookedFish> fishMap = new HashMap<String, CookedFish>();

    @Override
    public Map<String, CookedFish> provideCatalogMap() {
        HashMap<String, CookedFish> fishMap = new HashMap<String, CookedFish>();
        for (Map.Entry<String, CookedFish> entry : this.fishMap.entrySet()) {
            fishMap.put(entry.getKey().replace("cooked.", ""), entry.getValue());
        }
        return fishMap;
    }

    @Override
    public Optional<CookedFish> getById(String id) {
        return Optional.ofNullable(this.fishMap.get(Preconditions.checkNotNull(id).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<CookedFish> getAll() {
        return ImmutableList.copyOf(this.fishMap.values());
    }

    @Override
    public void registerDefaults() {
        for (ItemFishFood.FishType fishType : ItemFishFood.FishType.values()) {
            if (!fishType.func_150973_i()) continue;
            SpongeCookedFish cooked = new SpongeCookedFish(fishType.name(), new SpongeTranslation("item.fish." + fishType.func_150972_b() + ".cooked.name"), fishType);
            this.fishMap.put(cooked.getId().toLowerCase(Locale.ENGLISH), cooked);
        }
    }

    @AdditionalRegistration
    public void registerAdditional() {
        for (ItemFishFood.FishType fishType : ItemFishFood.FishType.values()) {
            if (!fishType.func_150973_i() || this.fishMap.containsKey(fishType.name().toLowerCase(Locale.ENGLISH))) continue;
            SpongeCookedFish cooked = new SpongeCookedFish(fishType.name(), new SpongeTranslation("item.fish." + fishType.func_150972_b() + ".cooked.name"), fishType);
            this.fishMap.put(cooked.getId().toLowerCase(Locale.ENGLISH), cooked);
        }
    }
}

