/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.item;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.spongepowered.api.item.FireworkShape;
import org.spongepowered.api.item.FireworkShapes;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.data.processor.common.FireworkUtils;
import org.spongepowered.common.item.SpongeFireworkShape;

public class FireworkShapeRegistryModule
implements CatalogRegistryModule<FireworkShape> {
    @RegisterCatalog(value=FireworkShapes.class)
    private Map<String, FireworkShape> fireworkShapeMap = new HashMap<String, FireworkShape>();

    @Override
    public Optional<FireworkShape> getById(String id) {
        if (!(id = Preconditions.checkNotNull(id).toLowerCase(Locale.ENGLISH)).contains(":")) {
            id = "minecraft:" + id;
        }
        return Optional.ofNullable(this.fireworkShapeMap.get(id));
    }

    @Override
    public Collection<FireworkShape> getAll() {
        return ImmutableList.copyOf(this.fireworkShapeMap.values());
    }

    @Override
    public void registerDefaults() {
        this.fireworkShapeMap.putAll(FireworkUtils.shapeMapping.values().stream().collect(Collectors.toMap(SpongeFireworkShape::getId, Function.identity())));
    }
}

