/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.item;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.inventory.ContainerBeacon;
import net.minecraft.inventory.ContainerBrewingStand;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.ContainerDispenser;
import net.minecraft.inventory.ContainerEnchantment;
import net.minecraft.inventory.ContainerFurnace;
import net.minecraft.inventory.ContainerHopper;
import net.minecraft.inventory.ContainerHorseInventory;
import net.minecraft.inventory.ContainerMerchant;
import net.minecraft.inventory.ContainerRepair;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityDropper;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntityHopper;
import org.spongepowered.api.item.inventory.InventoryArchetype;
import org.spongepowered.api.item.inventory.InventoryArchetypes;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.api.item.inventory.property.AcceptsItems;
import org.spongepowered.api.item.inventory.property.GuiIdProperty;
import org.spongepowered.api.item.inventory.property.GuiIds;
import org.spongepowered.api.item.inventory.property.InventoryDimension;
import org.spongepowered.api.item.inventory.property.InventoryTitle;
import org.spongepowered.api.item.inventory.property.SlotIndex;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.registry.util.RegistrationDependency;
import org.spongepowered.api.text.Text;
import org.spongepowered.common.item.inventory.SpongeInventoryBuilder;
import org.spongepowered.common.item.inventory.archetype.SlotArchetype;
import org.spongepowered.common.item.inventory.archetype.SpongeInventoryArchetypeBuilder;
import org.spongepowered.common.item.inventory.custom.CustomInventory;
import org.spongepowered.common.mixin.core.inventory.ContainerRepairAccessor;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;
import org.spongepowered.common.registry.type.item.GuiIdRegistryModule;
import org.spongepowered.common.text.translation.SpongeTranslation;

@RegistrationDependency(value={GuiIdRegistryModule.class})
public class InventoryArchetypeRegistryModule
implements AlternateCatalogRegistryModule<InventoryArchetype>,
SpongeAdditionalCatalogRegistryModule<InventoryArchetype> {
    @RegisterCatalog(value=InventoryArchetypes.class)
    private final Map<String, InventoryArchetype> mapping = new HashMap<String, InventoryArchetype>();

    public static InventoryArchetypeRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public Map<String, InventoryArchetype> provideCatalogMap() {
        HashMap<String, InventoryArchetype> map = new HashMap<String, InventoryArchetype>();
        map.putAll(this.mapping);
        for (Map.Entry<String, InventoryArchetype> entry : this.mapping.entrySet()) {
            map.put(entry.getKey().replace("minecraft:", "").replace("sponge:", ""), entry.getValue());
        }
        return map;
    }

    @Override
    public Optional<InventoryArchetype> getById(String id) {
        return Optional.ofNullable(this.mapping.get(Preconditions.checkNotNull(id).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<InventoryArchetype> getAll() {
        return ImmutableList.copyOf(this.mapping.values());
    }

    @Override
    public boolean allowsApiRegistration() {
        return true;
    }

    @Override
    public void registerAdditionalCatalog(InventoryArchetype archetype) {
        Preconditions.checkNotNull(archetype, "archetype");
        String id = archetype.getId();
        this.mapping.put(id.toLowerCase(Locale.ENGLISH), archetype);
    }

    @Override
    public void registerDefaults() {
        SlotArchetype SLOT = new SlotArchetype(ImmutableMap.of(CustomInventory.INVENTORY_DIMENSION, new InventoryDimension(1, 1)));
        SpongeInventoryArchetypeBuilder builder = new SpongeInventoryArchetypeBuilder();
        for (int i2 = 0; i2 < 9; ++i2) {
            builder.with(((SpongeInventoryArchetypeBuilder)new SpongeInventoryArchetypeBuilder().from(SLOT).property((InventoryProperty)SlotIndex.of(i2))).build("minecraft:slot" + i2, "Slot"));
        }
        InventoryArchetype MENU_ROW = ((SpongeInventoryArchetypeBuilder)builder.property((InventoryProperty)new InventoryDimension(9, 1))).build("sponge:menu_row", "Menu Row");
        InventoryArchetype MENU_COLUMN = ((SpongeInventoryArchetypeBuilder)builder.property((InventoryProperty)new InventoryDimension(9, 1))).build("sponge:menu_column", "Menu Column");
        InventoryArchetype MENU_GRID = ((SpongeInventoryArchetypeBuilder)builder.reset().with(MENU_ROW).with(MENU_ROW).with(MENU_ROW).property((InventoryProperty)new InventoryDimension(9, 3))).build("sponge:menu_grid", "Menu Grid");
        InventoryArchetype CHEST = ((SpongeInventoryArchetypeBuilder)((SpongeInventoryArchetypeBuilder)builder.reset().with(MENU_GRID).property((InventoryProperty)InventoryTitle.of(Text.of(new SpongeTranslation("container.chest"), new Object[0])))).property((InventoryProperty)new GuiIdProperty(GuiIds.CHEST))).container((i, p) -> new ContainerChest((IInventory)p.field_71071_by, i, p)).build("minecraft:chest", "Chest");
        InventoryArchetype DOUBLE_CHEST = ((SpongeInventoryArchetypeBuilder)((SpongeInventoryArchetypeBuilder)((SpongeInventoryArchetypeBuilder)builder.reset().with(CHEST).property((InventoryProperty)new InventoryDimension(9, 6))).property((InventoryProperty)InventoryTitle.of(Text.of(new SpongeTranslation("container.chestDouble"), new Object[0])))).property((InventoryProperty)new GuiIdProperty(GuiIds.CHEST))).container((i, p) -> new ContainerChest((IInventory)p.field_71071_by, i, p)).build("minecraft:double_chest", "DoubleChest");
        InventoryArchetype FURNACE = ((SpongeInventoryArchetypeBuilder)((SpongeInventoryArchetypeBuilder)((SpongeInventoryArchetypeBuilder)builder.reset().with(((SpongeInventoryArchetypeBuilder)new SpongeInventoryArchetypeBuilder().from(SLOT).property((InventoryProperty)new SlotIndex(0))).build("minecraft:furnace_input", "FurnaceInput")).with(((SpongeInventoryArchetypeBuilder)((SpongeInventoryArchetypeBuilder)new SpongeInventoryArchetypeBuilder().from(SLOT).property((InventoryProperty)new SlotIndex(1))).property((InventoryProperty)AcceptsItems.of(new Object[0]))).build("minecraft:furnace_fuel", "FurnaceFuel")).with(((SpongeInventoryArchetypeBuilder)((SpongeInventoryArchetypeBuilder)new SpongeInventoryArchetypeBuilder().from(SLOT).property((InventoryProperty)new SlotIndex(2))).property((InventoryProperty)AcceptsItems.of(new Object[0]))).build("minecraft:furnace_output", "FurnaceOutput")).property((InventoryProperty)new InventoryTitle(Text.of(new SpongeTranslation("container.furnace"), new Object[0])))).property((InventoryProperty)new InventoryDimension(3, 1))).property((InventoryProperty)new GuiIdProperty(GuiIds.FURNACE))).container((i, p) -> new ContainerFurnace(p.field_71071_by, i)).build("minecraft:furnace", "Furnace");
        InventoryArchetype DISPENSER = ((SpongeInventoryArchetypeBuilder)((SpongeInventoryArchetypeBuilder)((SpongeInventoryArchetypeBuilder)builder.reset().with(MENU_GRID).property((InventoryProperty)new InventoryDimension(3, 3))).property((InventoryProperty)InventoryTitle.of(Text.of(new SpongeTranslation("container.dispenser"), new Object[0])))).property((InventoryProperty)new GuiIdProperty(GuiIds.DISPENSER))).container((i, p) -> new ContainerDispenser((IInventory)p.field_71071_by, i)).build("minecraft:dispenser", "Dispenser");
        InventoryArchetype WORKBENCH = ((SpongeInventoryArchetypeBuilder)((SpongeInventoryArchetypeBuilder)builder.reset().with(((SpongeInventoryArchetypeBuilder)new SpongeInventoryArchetypeBuilder().from(MENU_GRID).property((InventoryProperty)new InventoryDimension(3, 3))).build("minecraft:workbench_grid", "Workbench Grid")).with((InventoryArchetype)SLOT).property((InventoryProperty)InventoryTitle.of(Text.of(new SpongeTranslation("container.crafting"), new Object[0])))).property((InventoryProperty)new GuiIdProperty(GuiIds.CRAFTING_TABLE))).container((i, p) -> {
            ContainerWorkbench container = new ContainerWorkbench(p.field_71071_by, p.func_130014_f_(), p.func_180425_c());
            for (int index = 0; index < container.field_75162_e.func_70302_i_(); ++index) {
                container.field_75162_e.func_70299_a(index, i.func_70301_a(index));
            }
            return container;
        }).build("minecraft:workbench", "Workbench");
        InventoryArchetype BREWING_STAND = ((SpongeInventoryArchetypeBuilder)((SpongeInventoryArchetypeBuilder)((SpongeInventoryArchetypeBuilder)builder.reset().with(MENU_ROW).property((InventoryProperty)new InventoryDimension(5, 1))).property((InventoryProperty)InventoryTitle.of(Text.of(new SpongeTranslation("container.brewing"), new Object[0])))).property((InventoryProperty)new GuiIdProperty(GuiIds.BREWING_STAND))).container((i, p) -> new ContainerBrewingStand(p.field_71071_by, i)).build("minecraft:brewing_stand", "BrewingStand");
        InventoryArchetype HOPPER = ((SpongeInventoryArchetypeBuilder)((SpongeInventoryArchetypeBuilder)((SpongeInventoryArchetypeBuilder)builder.reset().with(MENU_ROW).property((InventoryProperty)new InventoryDimension(5, 1))).property((InventoryProperty)InventoryTitle.of(Text.of(new SpongeTranslation("container.hopper"), new Object[0])))).property((InventoryProperty)new GuiIdProperty(GuiIds.HOPPER))).container((i, p) -> new ContainerHopper(p.field_71071_by, i, p)).build("minecraft:hopper", "Hopper");
        InventoryArchetype BEACON = ((SpongeInventoryArchetypeBuilder)((SpongeInventoryArchetypeBuilder)((SpongeInventoryArchetypeBuilder)builder.reset().with((InventoryArchetype)SLOT).property((InventoryProperty)new InventoryDimension(1, 1))).property((InventoryProperty)InventoryTitle.of(Text.of(new SpongeTranslation("container.beacon"), new Object[0])))).property((InventoryProperty)new GuiIdProperty(GuiIds.BEACON))).container((i, p) -> new ContainerBeacon((IInventory)p.field_71071_by, i)).build("minecraft:beacon", "Beacon");
        InventoryArchetype ENCHANTING_TABLE = ((SpongeInventoryArchetypeBuilder)((SpongeInventoryArchetypeBuilder)((SpongeInventoryArchetypeBuilder)builder.reset().with((InventoryArchetype)SLOT).with((InventoryArchetype)SLOT).property((InventoryProperty)new InventoryDimension(2, 1))).property((InventoryProperty)InventoryTitle.of(Text.of(new SpongeTranslation("container.enchant"), new Object[0])))).property((InventoryProperty)new GuiIdProperty(GuiIds.ENCHANTING_TABLE))).container((i, p) -> {
            ContainerEnchantment container = new ContainerEnchantment(p.field_71071_by, p.func_130014_f_(), p.func_180425_c());
            for (int index = 0; index < container.field_75168_e.func_70302_i_(); ++index) {
                container.field_75168_e.func_70299_a(index, i.func_70301_a(index));
            }
            return container;
        }).build("minecraft:enchanting_table", "EnchantingTable");
        InventoryArchetype ANVIL = ((SpongeInventoryArchetypeBuilder)((SpongeInventoryArchetypeBuilder)((SpongeInventoryArchetypeBuilder)builder.reset().with((InventoryArchetype)SLOT).with((InventoryArchetype)SLOT).with((InventoryArchetype)SLOT).property((InventoryProperty)new InventoryDimension(3, 1))).property((InventoryProperty)InventoryTitle.of(Text.of(new SpongeTranslation("container.repair"), new Object[0])))).property((InventoryProperty)new GuiIdProperty(GuiIds.ANVIL))).container((i, p) -> {
            ContainerRepair container = new ContainerRepair(p.field_71071_by, p.func_130014_f_(), p.func_180425_c(), p);
            for (int index = 0; index < ((ContainerRepairAccessor)container).accessor$getInputSlots().func_70302_i_(); ++index) {
                ((ContainerRepairAccessor)container).accessor$getInputSlots().func_70299_a(index, i.func_70301_a(index));
            }
            return container;
        }).build("minecraft:anvil", "Anvil");
        InventoryArchetype VILLAGER = ((SpongeInventoryArchetypeBuilder)((SpongeInventoryArchetypeBuilder)builder.reset().with((InventoryArchetype)SLOT).with((InventoryArchetype)SLOT).with((InventoryArchetype)SLOT).property((InventoryProperty)new InventoryDimension(3, 1))).property((InventoryProperty)new GuiIdProperty(GuiIds.VILLAGER))).container((i, p) -> {
            if (i instanceof CarriedInventory && ((CarriedInventory)i).getCarrier().isPresent() && ((CarriedInventory)i).getCarrier().get() instanceof IMerchant) {
                IMerchant merchant = (IMerchant)((CarriedInventory)i).getCarrier().get();
                ContainerMerchant container = new ContainerMerchant(p.field_71071_by, merchant, p.func_130014_f_());
                return container;
            }
            throw new IllegalArgumentException("Cannot open merchant inventory without a merchant as Carrier");
        }).build("minecraft:villager", "Villager");
        InventoryArchetype HORSE = ((SpongeInventoryArchetypeBuilder)((SpongeInventoryArchetypeBuilder)builder.reset().with((InventoryArchetype)SLOT).with((InventoryArchetype)SLOT).property((InventoryProperty)new InventoryDimension(2, 1))).property((InventoryProperty)new GuiIdProperty(GuiIds.HORSE))).container((i, p) -> {
            if (i instanceof CarriedInventory && ((CarriedInventory)i).getCarrier().isPresent() && ((CarriedInventory)i).getCarrier().get() instanceof AbstractHorse) {
                AbstractHorse horse = (AbstractHorse)((CarriedInventory)i).getCarrier().get();
                return new ContainerHorseInventory((IInventory)p.field_71071_by, i, horse, p);
            }
            throw new IllegalArgumentException("Cannot open horse inventory without a horse as Carrier");
        }).build("minecraft:horse", "Horse");
        InventoryArchetype HORSE_WITH_CHEST = ((SpongeInventoryArchetypeBuilder)builder.reset().with(HORSE).with(((SpongeInventoryArchetypeBuilder)new SpongeInventoryArchetypeBuilder().from(MENU_GRID).property((InventoryProperty)new InventoryDimension(5, 3))).build("horse_grid", "HorseGrid")).property((InventoryProperty)new GuiIdProperty(GuiIds.HORSE))).container((i, p) -> {
            if (i instanceof CarriedInventory && ((CarriedInventory)i).getCarrier().isPresent() && ((CarriedInventory)i).getCarrier().get() instanceof AbstractHorse) {
                AbstractHorse horse = (AbstractHorse)((CarriedInventory)i).getCarrier().get();
                return new ContainerHorseInventory((IInventory)p.field_71071_by, i, horse, p);
            }
            throw new IllegalArgumentException("Cannot open horse inventory without a horse as Carrier");
        }).build("minecraft:horse_with_chest", "Horse with Chest");
        InventoryArchetype CRAFTING = ((SpongeInventoryArchetypeBuilder)builder.reset().with((InventoryArchetype)SLOT).with(((SpongeInventoryArchetypeBuilder)new SpongeInventoryArchetypeBuilder().from(MENU_GRID).property((InventoryProperty)new InventoryDimension(2, 2))).build("minecraft:crafting_grid", "Crafting Grid")).property((InventoryProperty)InventoryTitle.of(Text.of(new SpongeTranslation("container.crafting"), new Object[0])))).build("minecraft:crafting", "Crafting");
        InventoryArchetype PLAYER = builder.reset().with(CRAFTING).with(((SpongeInventoryArchetypeBuilder)new SpongeInventoryArchetypeBuilder().from(MENU_GRID).property((InventoryProperty)new InventoryDimension(1, 4))).build("minecraft:armor", "Armor")).with(((SpongeInventoryArchetypeBuilder)new SpongeInventoryArchetypeBuilder().from(MENU_GRID).property((InventoryProperty)new InventoryDimension(9, 3))).build("minecraft:player_main", "Player Main")).with(((SpongeInventoryArchetypeBuilder)new SpongeInventoryArchetypeBuilder().from(MENU_GRID).property((InventoryProperty)new InventoryDimension(9, 1))).build("minecraft:player_hotbar", "Player Hotbar")).with(((SpongeInventoryArchetypeBuilder)new SpongeInventoryArchetypeBuilder().from(SLOT).property((InventoryProperty)new InventoryDimension(1, 1))).build("minecraft:player_offhand", "Player Offhand")).build("minecraft:player", "Player");
        InventoryArchetype UNKNOWN = builder.reset().build("minecraft:unknown", "UNKNOWN");
        this.registerAdditionalCatalog(SLOT);
        this.registerAdditionalCatalog(MENU_ROW);
        this.registerAdditionalCatalog(MENU_COLUMN);
        this.registerAdditionalCatalog(MENU_GRID);
        this.registerAdditionalCatalog(CHEST);
        SpongeInventoryBuilder.registerInventory(TileEntityChest.class, CHEST);
        SpongeInventoryBuilder.registerContainer(ContainerChest.class, CHEST);
        this.registerAdditionalCatalog(DOUBLE_CHEST);
        this.registerAdditionalCatalog(FURNACE);
        SpongeInventoryBuilder.registerInventory(TileEntityFurnace.class, FURNACE);
        SpongeInventoryBuilder.registerContainer(ContainerFurnace.class, FURNACE);
        this.registerAdditionalCatalog(DISPENSER);
        SpongeInventoryBuilder.registerInventory(TileEntityDispenser.class, DISPENSER);
        SpongeInventoryBuilder.registerInventory(TileEntityDropper.class, DISPENSER);
        SpongeInventoryBuilder.registerContainer(ContainerDispenser.class, DISPENSER);
        this.registerAdditionalCatalog(WORKBENCH);
        SpongeInventoryBuilder.registerContainer(ContainerWorkbench.class, WORKBENCH);
        this.registerAdditionalCatalog(BREWING_STAND);
        SpongeInventoryBuilder.registerInventory(TileEntityBrewingStand.class, BREWING_STAND);
        SpongeInventoryBuilder.registerContainer(ContainerBrewingStand.class, BREWING_STAND);
        this.registerAdditionalCatalog(HOPPER);
        SpongeInventoryBuilder.registerInventory(TileEntityHopper.class, HOPPER);
        SpongeInventoryBuilder.registerContainer(ContainerHopper.class, HOPPER);
        this.registerAdditionalCatalog(BEACON);
        SpongeInventoryBuilder.registerInventory(TileEntityBeacon.class, BEACON);
        SpongeInventoryBuilder.registerContainer(ContainerBeacon.class, BEACON);
        this.registerAdditionalCatalog(ENCHANTING_TABLE);
        SpongeInventoryBuilder.registerContainer(ContainerEnchantment.class, ENCHANTING_TABLE);
        this.registerAdditionalCatalog(ANVIL);
        SpongeInventoryBuilder.registerContainer(ContainerRepair.class, ANVIL);
        this.registerAdditionalCatalog(VILLAGER);
        SpongeInventoryBuilder.registerContainer(ContainerMerchant.class, VILLAGER);
        this.registerAdditionalCatalog(HORSE);
        SpongeInventoryBuilder.registerContainer(ContainerHorseInventory.class, HORSE);
        this.registerAdditionalCatalog(HORSE_WITH_CHEST);
        this.registerAdditionalCatalog(CRAFTING);
        this.registerAdditionalCatalog(PLAYER);
        this.registerAdditionalCatalog(UNKNOWN);
        InventoryArchetype MENU_ICON = builder.reset().with((InventoryArchetype)SLOT).build("sponge:menu_icon", "Menu Icon");
        InventoryArchetype MENU_BUTTON = builder.reset().with(MENU_ICON).build("sponge:menu_button", "Menu Button");
        InventoryArchetype MENU_CHECKBOX = builder.reset().with(MENU_ICON).build("sponge:menu_checkbox", "Menu Checkbox");
        InventoryArchetype MENU_SPINNER = builder.reset().with(MENU_ICON).build("sponge:menu_spinner", "Menu Spinner");
        this.registerAdditionalCatalog(MENU_ICON);
        this.registerAdditionalCatalog(MENU_BUTTON);
        this.registerAdditionalCatalog(MENU_CHECKBOX);
        this.registerAdditionalCatalog(MENU_SPINNER);
    }

    private InventoryArchetypeRegistryModule() {
    }

    private static final class Holder {
        static final InventoryArchetypeRegistryModule INSTANCE = new InventoryArchetypeRegistryModule();

        private Holder() {
        }
    }
}

