/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.item;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.potion.PotionType;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.api.item.potion.PotionTypes;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.util.AdditionalRegistration;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;

public final class PotionTypeRegistryModule
implements SpongeAdditionalCatalogRegistryModule<org.spongepowered.api.item.potion.PotionType>,
AlternateCatalogRegistryModule<org.spongepowered.api.item.potion.PotionType> {
    private final List<org.spongepowered.api.item.potion.PotionType> potionList = new ArrayList<org.spongepowered.api.item.potion.PotionType>();
    @RegisterCatalog(value=PotionTypes.class)
    private final Map<String, org.spongepowered.api.item.potion.PotionType> potionTypeMap = new HashMap<String, org.spongepowered.api.item.potion.PotionType>();

    public static PotionTypeRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public Map<String, org.spongepowered.api.item.potion.PotionType> provideCatalogMap() {
        HashMap<String, org.spongepowered.api.item.potion.PotionType> potionTypeMap = new HashMap<String, org.spongepowered.api.item.potion.PotionType>();
        for (Map.Entry<String, org.spongepowered.api.item.potion.PotionType> entry : this.potionTypeMap.entrySet()) {
            potionTypeMap.put(entry.getKey().replace("minecraft:", ""), entry.getValue());
        }
        return potionTypeMap;
    }

    @Override
    public Optional<org.spongepowered.api.item.potion.PotionType> getById(String id) {
        if (!Preconditions.checkNotNull(id).contains(":")) {
            id = "minecraft:" + id;
        }
        return Optional.ofNullable(this.potionTypeMap.get(Preconditions.checkNotNull(id).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<org.spongepowered.api.item.potion.PotionType> getAll() {
        return ImmutableList.copyOf(this.potionList);
    }

    @Override
    public void registerDefaults() {
        for (PotionType potion : PotionType.field_185176_a) {
            if (potion == null) continue;
            org.spongepowered.api.item.potion.PotionType potionType = (org.spongepowered.api.item.potion.PotionType)potion;
            this.potionList.add(potionType);
            this.potionTypeMap.put(((ResourceLocation)PotionType.field_185176_a.func_177774_c((Object)potion)).toString(), potionType);
        }
    }

    @AdditionalRegistration
    public void additionalRegistration() {
        for (PotionType potion : PotionType.field_185176_a) {
            org.spongepowered.api.item.potion.PotionType potionType;
            if (potion == null || this.potionList.contains(potionType = (org.spongepowered.api.item.potion.PotionType)potion)) continue;
            this.potionList.add(potionType);
            this.potionTypeMap.put(((ResourceLocation)PotionType.field_185176_a.func_177774_c((Object)potion)).toString(), potionType);
        }
    }

    @Override
    public boolean allowsApiRegistration() {
        return false;
    }

    @Override
    public void registerAdditionalCatalog(org.spongepowered.api.item.potion.PotionType extraCatalog) {
    }

    public void registerFromGameData(String id, org.spongepowered.api.item.potion.PotionType itemType) {
        this.potionTypeMap.put(id.toLowerCase(Locale.ENGLISH), itemType);
    }

    PotionTypeRegistryModule() {
    }

    private static final class Holder {
        static final PotionTypeRegistryModule INSTANCE = new PotionTypeRegistryModule();

        private Holder() {
        }
    }
}

