/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.item;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.item.Item;
import org.spongepowered.api.data.type.ToolType;
import org.spongepowered.api.data.type.ToolTypes;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.AdditionalRegistration;
import org.spongepowered.api.registry.util.RegisterCatalog;

public class ToolTypeRegistryModule
implements CatalogRegistryModule<ToolType> {
    @RegisterCatalog(value=ToolTypes.class)
    private final Map<String, ToolType> armorTypeMap = new HashMap<String, ToolType>();

    @Override
    public Optional<ToolType> getById(String id) {
        return Optional.ofNullable(this.armorTypeMap.get(Preconditions.checkNotNull(id).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<ToolType> getAll() {
        return ImmutableSet.copyOf(this.armorTypeMap.values());
    }

    @Override
    public void registerDefaults() {
        for (Item.ToolMaterial toolMaterial : Item.ToolMaterial.values()) {
            if (toolMaterial == Item.ToolMaterial.DIAMOND) {
                this.armorTypeMap.put("diamond", (ToolType)toolMaterial);
            }
            this.armorTypeMap.put(toolMaterial.name().toLowerCase(Locale.ENGLISH), (ToolType)toolMaterial);
        }
    }

    @AdditionalRegistration
    public void customRegistration() {
        for (Item.ToolMaterial toolMaterial : Item.ToolMaterial.values()) {
            if (this.armorTypeMap.containsKey(toolMaterial.name().toLowerCase(Locale.ENGLISH))) continue;
            this.armorTypeMap.put(toolMaterial.name().toLowerCase(Locale.ENGLISH), (ToolType)toolMaterial);
        }
    }
}

