/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.scoreboard;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.text.TextFormatting;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.registry.util.RegistrationDependency;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlot;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlots;
import org.spongepowered.common.registry.type.text.TextColorRegistryModule;
import org.spongepowered.common.scoreboard.SpongeDisplaySlot;
import org.spongepowered.common.text.format.SpongeTextColor;

@RegistrationDependency(value={TextColorRegistryModule.class})
public final class DisplaySlotRegistryModule
implements AlternateCatalogRegistryModule<DisplaySlot> {
    @RegisterCatalog(value=DisplaySlots.class)
    public final Map<String, SpongeDisplaySlot> displaySlotMappings = Maps.newLinkedHashMap();

    public static DisplaySlotRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    public Optional<DisplaySlot> getForIndex(int id) {
        return Optional.ofNullable(Iterables.get(this.displaySlotMappings.values(), id, null));
    }

    @Override
    public Optional<DisplaySlot> getById(String id) {
        return Optional.ofNullable(this.displaySlotMappings.get(Preconditions.checkNotNull(id).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<DisplaySlot> getAll() {
        return ImmutableList.copyOf(this.displaySlotMappings.values());
    }

    @Override
    public void registerDefaults() {
        this.displaySlotMappings.put("minecraft:list", new SpongeDisplaySlot("list", null, 0));
        this.displaySlotMappings.put("minecraft:sidebar", new SpongeDisplaySlot("sidebar", null, 1));
        this.displaySlotMappings.put("minecraft:below_name", new SpongeDisplaySlot("below_name", null, 2));
        for (Map.Entry<TextFormatting, SpongeTextColor> entry : TextColorRegistryModule.enumChatColor.entrySet()) {
            String id = entry.getValue().getId().toLowerCase(Locale.ENGLISH);
            SpongeDisplaySlot value = new SpongeDisplaySlot(id, entry.getValue(), entry.getKey().func_175746_b() + 3);
            this.displaySlotMappings.put("minecraft:" + id, value);
        }
    }

    DisplaySlotRegistryModule() {
    }

    @Override
    public Map<String, DisplaySlot> provideCatalogMap() {
        HashMap<String, DisplaySlot> map = new HashMap<String, DisplaySlot>();
        for (Map.Entry<String, SpongeDisplaySlot> entry : this.displaySlotMappings.entrySet()) {
            map.put(entry.getKey().replace("minecraft:", ""), entry.getValue());
        }
        return map;
    }

    private static final class Holder {
        static final DisplaySlotRegistryModule INSTANCE = new DisplaySlotRegistryModule();

        private Holder() {
        }
    }
}

