/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.scoreboard;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.scoreboard.IScoreCriteria;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.scoreboard.objective.displaymode.ObjectiveDisplayMode;
import org.spongepowered.api.scoreboard.objective.displaymode.ObjectiveDisplayModes;

public final class ObjectiveDisplayModeRegistryModule
implements CatalogRegistryModule<ObjectiveDisplayMode> {
    @RegisterCatalog(value=ObjectiveDisplayModes.class)
    private final Map<String, ObjectiveDisplayMode> objectiveDisplayModeMappings = new ImmutableMap.Builder<String, ObjectiveDisplayMode>().put("integer", (ObjectiveDisplayMode)IScoreCriteria.EnumRenderType.INTEGER).put("hearts", (ObjectiveDisplayMode)IScoreCriteria.EnumRenderType.HEARTS).build();

    @Override
    public Optional<ObjectiveDisplayMode> getById(String id) {
        return Optional.ofNullable(this.objectiveDisplayModeMappings.get(Preconditions.checkNotNull(id).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<ObjectiveDisplayMode> getAll() {
        return ImmutableList.copyOf(this.objectiveDisplayModeMappings.values());
    }
}

