/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.statistic;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.statistic.Statistic;
import org.spongepowered.api.statistic.Statistics;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;

public final class StatisticRegistryModule
implements SpongeAdditionalCatalogRegistryModule<Statistic>,
AlternateCatalogRegistryModule<Statistic> {
    @RegisterCatalog(value=Statistics.class)
    private final Map<String, Statistic> statisticMappings = Maps.newHashMap();
    private static final ImmutableMap<String, String> MINECRAFT_SPONGE_ID_MAPPINGS = ImmutableMap.builder().put("shulker_box_opened", "open_shulker_box").put("play_one_minute", "time_played").build();

    public static StatisticRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    private StatisticRegistryModule() {
    }

    @Override
    public Optional<Statistic> getById(String id) {
        return Optional.ofNullable(this.statisticMappings.get(id.toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<Statistic> getAll() {
        return ImmutableList.copyOf(this.statisticMappings.values());
    }

    @Override
    public void registerAdditionalCatalog(Statistic stat) {
        Preconditions.checkNotNull(stat, "null statistic");
        this.statisticMappings.put(stat.getId().toLowerCase(Locale.ENGLISH), stat);
    }

    @Override
    public boolean allowsApiRegistration() {
        return false;
    }

    @Override
    public Map<String, Statistic> provideCatalogMap() {
        HashMap<String, Statistic> map = new HashMap<String, Statistic>();
        for (Map.Entry<String, Statistic> entry : this.statisticMappings.entrySet()) {
            String key = entry.getKey();
            String alternateKey = MINECRAFT_SPONGE_ID_MAPPINGS.get(key);
            if (alternateKey != null) {
                map.put(alternateKey, entry.getValue());
                continue;
            }
            map.put(key, entry.getValue());
        }
        return map;
    }

    private static final class Holder {
        static final StatisticRegistryModule INSTANCE = new StatisticRegistryModule();

        private Holder() {
        }
    }
}

