/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.text;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.text.selector.SelectorType;
import org.spongepowered.api.text.selector.SelectorTypes;
import org.spongepowered.common.text.selector.SpongeSelectorType;

public final class SelectorTypeRegistryModule
implements AlternateCatalogRegistryModule<SelectorType> {
    @RegisterCatalog(value=SelectorTypes.class)
    private final Map<String, SelectorType> selectorMappings = Maps.newHashMap();

    @Override
    public Optional<SelectorType> getById(String id) {
        return Optional.ofNullable(this.selectorMappings.get(Preconditions.checkNotNull(id).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<SelectorType> getAll() {
        return ImmutableList.copyOf(this.selectorMappings.values());
    }

    @Override
    public void registerDefaults() {
        this.selectorMappings.put("minecraft:all_players", new SpongeSelectorType("minecraft:all_players", "a"));
        this.selectorMappings.put("minecraft:all_entities", new SpongeSelectorType("minecraft:all_entities", "e"));
        this.selectorMappings.put("minecraft:nearest_player", new SpongeSelectorType("minecraft:nearest_player", "p"));
        this.selectorMappings.put("minecraft:source", new SpongeSelectorType("minecraft:source", "s"));
        this.selectorMappings.put("minecraft:random", new SpongeSelectorType("minecraft:random", "r"));
    }

    @Override
    public Map<String, SelectorType> provideCatalogMap() {
        HashMap<String, SelectorType> map = new HashMap<String, SelectorType>();
        for (Map.Entry<String, SelectorType> entry : this.selectorMappings.entrySet()) {
            map.put(entry.getKey().replace("minecraft:", ""), entry.getValue());
        }
        return map;
    }
}

