/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.world.gen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import org.spongepowered.api.registry.AdditionalCatalogRegistryModule;
import org.spongepowered.api.registry.util.AdditionalRegistration;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.biome.BiomeTypes;
import org.spongepowered.api.world.biome.VirtualBiomeType;
import org.spongepowered.common.bridge.world.biome.BiomeBridge;
import org.spongepowered.common.registry.RegistryHelper;
import org.spongepowered.common.registry.type.AbstractPrefixAlternateCatalogTypeRegistryModule;

@RegisterCatalog(value=BiomeTypes.class)
public final class BiomeTypeRegistryModule
extends AbstractPrefixAlternateCatalogTypeRegistryModule<BiomeType>
implements AdditionalCatalogRegistryModule<BiomeType> {
    private final List<BiomeType> biomeTypes = new ArrayList<BiomeType>();
    public static final ImmutableMap<String, String> MINECRAFT_TO_SPONGE_FIELD_NAMES = ImmutableMap.builder().put("ice_flats", "ice_plains").put("beaches", "beach").put("smaller_extreme_hills", "extreme_hills_edge").put("birch_forest_hills", "birch_forest_hills").put("roofed_forest", "roofed_forest").put("taiga_cold", "cold_taiga").put("taiga_cold_hills", "cold_taiga_hills").put("redwood_taiga", "mega_taiga").put("redwood_taiga_hills", "mega_taiga_hills").put("extreme_hills_with_trees", "extreme_hills_plus").put("savanna_rock", "savanna_plateau").put("mesa_rock", "mesa_plateau_forest").put("mesa_clear_rock", "mesa_plateau").put("mutated_plains", "sunflower_plains").put("mutated_desert", "desert_mountains").put("mutated_extreme_hills", "extreme_hills_mountains").put("mutated_forest", "flower_forest").put("mutated_taiga", "taiga_mountains").put("mutated_swampland", "swampland_mountains").put("mutated_ice_flats", "ice_plains_spikes").put("mutated_jungle", "jungle_mountains").put("mutated_jungle_edge", "jungle_edge_mountains").put("mutated_birch_forest", "birch_forest_mountains").put("mutated_birch_forest_hills", "birch_forest_hills_mountains").put("mutated_roofed_forest", "roofed_forest_mountains").put("mutated_taiga_cold", "cold_taiga_mountains").put("mutated_redwood_taiga", "mega_spruce_taiga").put("mutated_redwood_taiga_hills", "mega_spruce_taiga_hills").put("mutated_extreme_hills_with_trees", "extreme_hills_plus_mountains").put("mutated_savanna", "savanna_mountains").put("mutated_savanna_rock", "savanna_plateau_mountains").put("mutated_mesa", "mesa_bryce").put("mutated_mesa_rock", "mesa_plateau_forest_mountains").put("mutated_mesa_clear_rock", "mesa_plateau_mountains").build();

    public BiomeTypeRegistryModule() {
        super("minecraft", new String[]{"minecraft:"}, string -> {
            String alternateKey = MINECRAFT_TO_SPONGE_FIELD_NAMES.get(string);
            return alternateKey == null ? string : alternateKey;
        });
    }

    @Override
    public void registerDefaults() {
        for (Biome biome : Biome.field_185377_q) {
            if (biome == null) continue;
            String id = ((BiomeType)biome).getId();
            if (id == null) {
                ResourceLocation reg_id = (ResourceLocation)Biome.field_185377_q.func_177774_c((Object)biome);
                ((BiomeBridge)biome).bridge$setModId(reg_id.func_110624_b());
                id = reg_id.toString();
                ((BiomeBridge)biome).bridge$setId(id);
            }
            this.biomeTypes.add((BiomeType)biome);
            this.catalogTypeMap.put(id, (BiomeType)biome);
        }
    }

    @AdditionalRegistration
    public void registerAdditional() {
        for (Biome biome : Biome.field_185377_q) {
            if (biome == null || this.biomeTypes.contains(biome)) continue;
            String id = ((BiomeType)biome).getId();
            if (id == null) {
                ResourceLocation reg_id = (ResourceLocation)Biome.field_185377_q.func_177774_c((Object)biome);
                ((BiomeBridge)biome).bridge$setModId(reg_id.func_110624_b());
                id = reg_id.toString();
                ((BiomeBridge)biome).bridge$setId(id);
            }
            this.biomeTypes.add((BiomeType)biome);
            this.catalogTypeMap.put(id, (BiomeType)biome);
        }
        RegistryHelper.mapFields(BiomeTypes.class, this.provideCatalogMap());
    }

    @Override
    public void registerAdditionalCatalog(BiomeType biome) {
        Preconditions.checkNotNull(biome);
        Preconditions.checkArgument(biome instanceof VirtualBiomeType, "Cannot register non-virtual biomes at this time.");
        Preconditions.checkArgument(!this.getById(biome.getId()).isPresent(), "Duplicate biome id");
        this.biomeTypes.add(biome);
    }
}

