/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.RegistrationPhase;
import org.spongepowered.api.registry.RegistryModule;
import org.spongepowered.api.registry.util.AdditionalRegistration;
import org.spongepowered.api.registry.util.CustomCatalogRegistration;
import org.spongepowered.api.registry.util.DelayedRegistration;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.registry.RegistryHelper;

public final class RegistryModuleLoader {
    private RegistryModuleLoader() {
    }

    public static boolean tryModulePhaseRegistration(RegistryModule module) {
        try {
            Method method = RegistryModuleLoader.getCustomRegistration(module);
            if (method != null) {
                if (RegistryModuleLoader.isCustomProperPhase(method)) {
                    RegistryModuleLoader.invokeCustomRegistration(module, method);
                    return true;
                }
                return false;
            }
            if (RegistryModuleLoader.isDefaultProperPhase(module)) {
                module.registerDefaults();
                RegisterCatalog regAnnot = RegistryModuleLoader.getRegisterCatalogAnnot(module);
                if (regAnnot != null) {
                    Map<String, ?> map = RegistryModuleLoader.getCatalogMap(module);
                    if (map.isEmpty()) {
                        SpongeImpl.getLogger().warn("{} has an empty CatalogMap. Implement registerDefaults() or use the CustomCatalogRegistration annotation", (Object)module.getClass().getCanonicalName());
                        return true;
                    }
                    HashSet<String> ignored = regAnnot.ignoredFields().length == 0 ? null : Sets.newHashSet(regAnnot.ignoredFields());
                    RegistryHelper.mapFields(regAnnot.value(), map, ignored);
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException("Error trying to initialize module: " + module.getClass().getCanonicalName(), e);
        }
    }

    @Nullable
    private static Method getCustomRegistration(RegistryModule module) {
        for (Method method : module.getClass().getMethods()) {
            CustomCatalogRegistration registration = method.getDeclaredAnnotation(CustomCatalogRegistration.class);
            if (registration == null) continue;
            return method;
        }
        return null;
    }

    @Nullable
    private static RegisterCatalog getRegisterCatalogAnnot(RegistryModule module) {
        RegisterCatalog catalog = module.getClass().getAnnotation(RegisterCatalog.class);
        if (catalog != null) {
            return catalog;
        }
        for (Field field : module.getClass().getDeclaredFields()) {
            RegisterCatalog annotation = field.getAnnotation(RegisterCatalog.class);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    private static boolean isDefaultProperPhase(RegistryModule module) {
        try {
            Method method = module.getClass().getMethod("registerDefaults", new Class[0]);
            DelayedRegistration delay = method.getDeclaredAnnotation(DelayedRegistration.class);
            if (delay == null) {
                return true;
            }
            return SpongeImpl.getRegistry().getPhase() == delay.value();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean isCustomProperPhase(Method custom) {
        DelayedRegistration delay = custom.getDeclaredAnnotation(DelayedRegistration.class);
        if (delay == null) {
            return SpongeImpl.getRegistry().getPhase() == RegistrationPhase.PRE_REGISTRY;
        }
        return SpongeImpl.getRegistry().getPhase() == delay.value();
    }

    private static Map<String, ?> getCatalogMap(RegistryModule module) {
        if (module instanceof AlternateCatalogRegistryModule) {
            return Preconditions.checkNotNull(((AlternateCatalogRegistryModule)module).provideCatalogMap(), "Provided CatalogMap can't be null");
        }
        for (Field field : module.getClass().getDeclaredFields()) {
            RegisterCatalog annotation = field.getAnnotation(RegisterCatalog.class);
            if (annotation == null) continue;
            try {
                field.setAccessible(true);
                Map map = (Map)field.get(module);
                return Preconditions.checkNotNull(map);
            }
            catch (Exception e) {
                SpongeImpl.getLogger().error("Failed to retrieve a registry field from module: " + module.getClass().getCanonicalName());
            }
        }
        throw new IllegalStateException("Registry module does not have a catalog map! Registry: " + module.getClass().getCanonicalName());
    }

    private static void invokeCustomRegistration(RegistryModule module, Method method) {
        try {
            method.invoke((Object)module, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            SpongeImpl.getLogger().error("Error when calling custom catalog registration for module: " + module.getClass().getCanonicalName(), (Throwable)e);
        }
    }

    public static void tryAdditionalRegistration(RegistryModule module) {
        Method additionalRegistration = RegistryModuleLoader.getAdditionalMethod(module);
        if (additionalRegistration != null) {
            try {
                additionalRegistration.invoke((Object)module, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private static Method getAdditionalMethod(RegistryModule module) {
        for (Method method : module.getClass().getMethods()) {
            AdditionalRegistration registration = method.getDeclaredAnnotation(AdditionalRegistration.class);
            if (registration == null) continue;
            return method;
        }
        return null;
    }
}

