/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.relocate.co.aikar.timings;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import org.spongepowered.api.block.tileentity.TileEntityType;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.common.entity.SpongeEntityType;
import org.spongepowered.common.registry.type.block.TileEntityTypeRegistryModule;

final class TimingsPls {
    private static final Object2IntMap<EntityType> ENTITY_IDS = new Object2IntOpenHashMap<EntityType>();
    private static final Object2IntMap<TileEntityType> TILE_ENTITY_IDS = new Object2IntOpenHashMap<TileEntityType>();
    private static final int NOT_FOUND = Integer.MIN_VALUE;
    private static int nextEntityId = 56991891;
    private static int nextTileEntityId = 13221456;

    TimingsPls() {
    }

    public static int getEntityId(EntityType type) {
        if (type instanceof SpongeEntityType) {
            return ((SpongeEntityType)type).entityTypeId;
        }
        int fake = ENTITY_IDS.getInt(type);
        if (fake == Integer.MIN_VALUE) {
            fake = nextEntityId++;
            ENTITY_IDS.put(type, fake);
        }
        return fake;
    }

    public static int getTileEntityId(TileEntityType type) {
        int fake = TILE_ENTITY_IDS.getInt(type);
        if (fake == Integer.MIN_VALUE) {
            fake = nextTileEntityId++;
            TILE_ENTITY_IDS.put(type, fake);
        }
        return fake;
    }

    static {
        ENTITY_IDS.defaultReturnValue(Integer.MIN_VALUE);
        int count = -1;
        for (TileEntityType tileEntityType : TileEntityTypeRegistryModule.getInstance().getAll()) {
            TILE_ENTITY_IDS.put(tileEntityType, count++);
        }
    }
}

