/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.relocate.co.aikar.timings;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.source.ConsoleSource;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.channel.MessageReceiver;

public final class TimingsReportListener {
    private final List<MessageChannel> channels;
    private final Runnable onDone;
    private String timingsURL;
    private MessageChannel combinedChannel;

    public TimingsReportListener(CommandSource channels) {
        this(channels, null);
    }

    public TimingsReportListener(CommandSource sender, Runnable onDone) {
        this(Lists.newArrayList(MessageChannel.fixed(sender)), onDone);
    }

    public TimingsReportListener(List<MessageChannel> channels) {
        this(channels, null);
    }

    public TimingsReportListener(List<MessageChannel> channels, Runnable onDone) {
        Validate.notNull(channels);
        Validate.notEmpty(channels);
        this.channels = Lists.newArrayList(channels);
        this.addConsoleIfNeeded(this.channels);
        this.onDone = onDone;
        this.combinedChannel = MessageChannel.combined(this.channels);
    }

    public String getTimingsURL() {
        return this.timingsURL;
    }

    public void done() {
        this.done(null);
    }

    public void done(String url) {
        this.timingsURL = url;
        if (this.onDone != null) {
            this.onDone.run();
        }
    }

    public void addConsoleIfNeeded(List<MessageChannel> channels) {
        boolean hasConsole = false;
        block0: for (MessageChannel channel : channels) {
            for (MessageReceiver receiver : channel.getMembers()) {
                if (!(receiver instanceof ConsoleSource)) continue;
                hasConsole = true;
                continue block0;
            }
        }
        if (!hasConsole) {
            channels.add(MessageChannel.TO_CONSOLE);
        }
    }

    public void send(Text text) {
        this.combinedChannel.send(text);
    }

    public MessageChannel getChannel() {
        return this.combinedChannel;
    }
}

