/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.resourcepack;

import com.google.common.base.Preconditions;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.spongepowered.api.resourcepack.ResourcePack;
import org.spongepowered.api.resourcepack.ResourcePackFactory;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.resourcepack.SpongeResourcePack;

public final class SpongeResourcePackFactory
implements ResourcePackFactory {
    @Override
    public ResourcePack fromUri(URI uri) throws FileNotFoundException {
        Preconditions.checkNotNull(uri, "uri");
        try {
            Hasher hasher = Hashing.sha1().newHasher();
            try (InputStream in = SpongeResourcePackFactory.openStream(uri);){
                int read;
                byte[] buf = new byte[256];
                while ((read = in.read(buf)) > 0) {
                    hasher.putBytes(buf, 0, read);
                }
            }
            return SpongeResourcePack.create(uri, hasher.hash().toString());
        }
        catch (IOException e) {
            FileNotFoundException ex = new FileNotFoundException(e.toString());
            ex.initCause(e);
            throw ex;
        }
    }

    private static InputStream openStream(URI uri) throws IOException {
        if (uri.toString().startsWith("level://")) {
            return Files.newInputStream(SpongeImpl.getGameDir().resolve(uri.toString().substring("level://".length())), new OpenOption[0]);
        }
        return uri.toURL().openStream();
    }

    @Override
    public ResourcePack fromUriUnchecked(URI uri) {
        return SpongeResourcePack.create(Preconditions.checkNotNull(uri, "uri"), null);
    }
}

