/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scheduler;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.common.scheduler.ScheduledTask;
import org.spongepowered.common.scheduler.SpongeScheduler;

public class SpongeTaskBuilder
implements Task.Builder {
    private final SpongeScheduler scheduler;
    private Consumer<Task> consumer;
    private ScheduledTask.TaskSynchronicity syncType;
    private String name;
    private long delay;
    private long interval;
    private boolean delayIsTicks;
    private boolean intervalIsTicks;

    public SpongeTaskBuilder(SpongeScheduler scheduler) {
        this.scheduler = scheduler;
        this.syncType = ScheduledTask.TaskSynchronicity.SYNCHRONOUS;
    }

    @Override
    public Task.Builder async() {
        this.syncType = ScheduledTask.TaskSynchronicity.ASYNCHRONOUS;
        return this;
    }

    @Override
    public Task.Builder execute(Consumer<Task> executor) {
        this.consumer = Preconditions.checkNotNull(executor, "executor");
        return this;
    }

    @Override
    public Task.Builder delay(long delay, TimeUnit unit) {
        Preconditions.checkArgument(delay >= 0L, "Delay cannot be negative");
        this.delay = Preconditions.checkNotNull(unit, "unit").toNanos(delay);
        this.delayIsTicks = false;
        return this;
    }

    @Override
    public Task.Builder delayTicks(long delay) {
        Preconditions.checkArgument(delay >= 0L, "Delay cannot be negative");
        this.delay = delay;
        this.delayIsTicks = true;
        return this;
    }

    @Override
    public Task.Builder interval(long interval, TimeUnit unit) {
        Preconditions.checkArgument(interval >= 0L, "Interval cannot be negative");
        this.interval = Preconditions.checkNotNull(unit, "unit").toNanos(interval);
        this.intervalIsTicks = false;
        return this;
    }

    @Override
    public Task.Builder intervalTicks(long interval) {
        Preconditions.checkArgument(interval >= 0L, "Interval cannot be negative");
        this.interval = interval;
        this.intervalIsTicks = true;
        return this;
    }

    @Override
    public Task.Builder name(String name) {
        Preconditions.checkArgument(Preconditions.checkNotNull(name, "name").length() > 0, "Name cannot be empty");
        this.name = name;
        return this;
    }

    @Override
    public Task submit(Object plugin) {
        PluginContainer pluginContainer = this.scheduler.checkPluginInstance(plugin);
        Preconditions.checkState(this.consumer != null, "Runnable task not set");
        String name = this.name == null ? this.scheduler.getNameFor(pluginContainer, this.syncType) : this.name;
        long delay = this.delay;
        long interval = this.interval;
        boolean delayIsTicks = this.delayIsTicks;
        boolean intervalIsTicks = this.intervalIsTicks;
        if (this.syncType == ScheduledTask.TaskSynchronicity.ASYNCHRONOUS) {
            delay = delayIsTicks ? delay * SpongeScheduler.TICK_DURATION_NS : delay;
            interval = intervalIsTicks ? interval * SpongeScheduler.TICK_DURATION_NS : interval;
            intervalIsTicks = false;
            delayIsTicks = false;
        }
        ScheduledTask task = new ScheduledTask(this.syncType, this.consumer, name, delay, delayIsTicks, interval, intervalIsTicks, pluginContainer);
        this.scheduler.submit(task);
        return task;
    }

    @Override
    public Task.Builder from(Task value) {
        this.syncType = value.isAsynchronous() ? ScheduledTask.TaskSynchronicity.ASYNCHRONOUS : ScheduledTask.TaskSynchronicity.SYNCHRONOUS;
        this.consumer = value.getConsumer();
        this.interval = value.getInterval();
        this.delay = value.getDelay();
        this.delayIsTicks = false;
        this.name = value.getName();
        return this;
    }

    @Override
    public Task.Builder reset() {
        this.syncType = ScheduledTask.TaskSynchronicity.SYNCHRONOUS;
        this.consumer = null;
        this.interval = 0L;
        this.delay = 0L;
        this.delayIsTicks = false;
        this.name = null;
        return this;
    }
}

