/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scoreboard.builder;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import net.minecraft.scoreboard.IScoreCriteria;
import org.spongepowered.api.scoreboard.critieria.Criterion;
import org.spongepowered.api.scoreboard.objective.Objective;
import org.spongepowered.api.scoreboard.objective.displaymode.ObjectiveDisplayMode;
import org.spongepowered.api.text.Text;
import org.spongepowered.common.scoreboard.SpongeObjective;

public class SpongeObjectiveBuilder
implements Objective.Builder {
    private static final int MAX_NAME_LENGTH = 16;
    @Nullable
    private String name;
    @Nullable
    private Text displayName;
    @Nullable
    private Criterion criterion;
    @Nullable
    private ObjectiveDisplayMode objectiveDisplayMode;

    @Override
    public Objective.Builder name(String name) {
        Preconditions.checkNotNull(name, "Name cannot be null");
        Preconditions.checkArgument(16 >= name.length(), "name '%s' is too long: %s characters over limit of %s", (Object)name, (Object)(16 - name.length()), (Object)16);
        this.name = name;
        return this;
    }

    @Override
    public Objective.Builder displayName(Text displayName) {
        Preconditions.checkNotNull(displayName, "DisplayName cannot be null");
        this.displayName = displayName;
        return this;
    }

    @Override
    public Objective.Builder criterion(Criterion criterion) {
        Preconditions.checkNotNull(criterion, "Criterion cannot be null");
        this.criterion = criterion;
        return this;
    }

    @Override
    public Objective.Builder objectiveDisplayMode(ObjectiveDisplayMode objectiveDisplayMode) {
        Preconditions.checkNotNull(objectiveDisplayMode, "ObjectiveDisplayMode cannot be null");
        this.objectiveDisplayMode = objectiveDisplayMode;
        return this;
    }

    @Override
    public Objective.Builder from(Objective value) {
        this.name = value.getName();
        this.displayName = value.getDisplayName();
        this.criterion = value.getCriterion();
        this.objectiveDisplayMode = value.getDisplayMode();
        return this;
    }

    @Override
    public SpongeObjectiveBuilder reset() {
        this.name = null;
        this.displayName = null;
        this.criterion = null;
        this.objectiveDisplayMode = null;
        return this;
    }

    @Override
    public Objective build() throws IllegalStateException {
        Preconditions.checkState(this.name != null, "Name cannot be null");
        Preconditions.checkState(this.criterion != null, "Criterion cannot be null");
        SpongeObjective objective = new SpongeObjective(this.name, this.criterion);
        if (this.displayName != null) {
            objective.setDisplayName(this.displayName);
        }
        if (this.objectiveDisplayMode != null) {
            objective.setDisplayMode(this.objectiveDisplayMode);
        } else if (this.criterion instanceof IScoreCriteria) {
            objective.setDisplayMode((ObjectiveDisplayMode)((IScoreCriteria)this.criterion).func_178790_c());
        }
        return objective;
    }
}

