/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.pagination;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.common.service.pagination.ActivePagination;
import org.spongepowered.common.service.pagination.PaginationCalculator;
import org.spongepowered.common.util.SpongeCommonTranslationHelper;

class IterablePagination
extends ActivePagination {
    private final PeekingIterator<Map.Entry<Text, Integer>> countIterator;
    private int lastPage;

    public IterablePagination(Supplier<Optional<MessageReceiver>> src, PaginationCalculator calc, Iterable<Map.Entry<Text, Integer>> counts, @Nullable Text title, @Nullable Text header, @Nullable Text footer, Text padding) {
        super(src, calc, title, header, footer, padding);
        this.countIterator = Iterators.peekingIterator(counts.iterator());
    }

    @Override
    protected Iterable<Text> getLines(int page) throws CommandException {
        Map.Entry<Text, Integer> ent;
        if (!this.countIterator.hasNext()) {
            throw new CommandException(SpongeCommonTranslationHelper.t("You're already at the end of the pagination list iterator.", new Object[0]));
        }
        if (page < 1) {
            throw new CommandException(SpongeCommonTranslationHelper.t("Page %s does not exist!", page));
        }
        if (page <= this.lastPage) {
            throw new CommandException(SpongeCommonTranslationHelper.t("You cannot go to previous pages in an iterable pagination.", new Object[0]));
        }
        if (page > this.lastPage + 1) {
            this.getLines(page - 1);
        }
        this.lastPage = page;
        if (this.getMaxContentLinesPerPage() <= 0) {
            return Lists.newArrayList(Iterators.transform(this.countIterator, new Function<Map.Entry<Text, Integer>, Text>(){

                @Override
                @Nullable
                public Text apply(Map.Entry<Text, Integer> input) {
                    return input.getKey();
                }
            }));
        }
        ArrayList<Text> ret = new ArrayList<Text>(this.getMaxContentLinesPerPage());
        for (int addedLines = 0; addedLines <= this.getMaxContentLinesPerPage(); addedLines += ent.getValue().intValue()) {
            if (!this.countIterator.hasNext()) {
                if (page <= 1) break;
                this.padPage(ret, addedLines, false);
                break;
            }
            if (addedLines + this.countIterator.peek().getValue() > this.getMaxContentLinesPerPage()) {
                this.padPage(ret, addedLines, true);
                break;
            }
            ent = this.countIterator.next();
            ret.add(ent.getKey());
        }
        return ret;
    }

    @Override
    protected boolean hasPrevious(int page) {
        return false;
    }

    @Override
    protected boolean hasNext(int page) {
        return page == this.getCurrentPage() && this.countIterator.hasNext();
    }

    @Override
    protected int getTotalPages() {
        return -1;
    }

    @Override
    public void previousPage() throws CommandException {
        throw new CommandException(SpongeCommonTranslationHelper.t("You cannot go to previous pages in an iterable pagination.", new Object[0]));
    }
}

