/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.pagination;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.common.service.pagination.ActivePagination;
import org.spongepowered.common.service.pagination.PaginationCalculator;
import org.spongepowered.common.util.SpongeCommonTranslationHelper;

class ListPagination
extends ActivePagination {
    private final List<List<Text>> pages;

    public ListPagination(Supplier<Optional<MessageReceiver>> src, PaginationCalculator calc, List<Map.Entry<Text, Integer>> lines, @Nullable Text title, @Nullable Text header, @Nullable Text footer, Text padding) {
        super(src, calc, title, header, footer, padding);
        boolean lastPageNotEmpty;
        ArrayList<List<Text>> pages = new ArrayList<List<Text>>();
        ArrayList<Text> currentPage = new ArrayList<Text>();
        int currentPageLines = 0;
        for (Map.Entry<Text, Integer> ent : lines) {
            boolean spillToNextPage;
            boolean finiteLinesPerPage = this.getMaxContentLinesPerPage() > 0;
            boolean willExceedPageLength = ent.getValue() + currentPageLines > this.getMaxContentLinesPerPage();
            boolean currentPageNotEmpty = currentPageLines != 0;
            boolean bl2 = spillToNextPage = finiteLinesPerPage && willExceedPageLength && currentPageNotEmpty;
            if (spillToNextPage) {
                this.padPage(currentPage, currentPageLines, true);
                currentPageLines = 0;
                pages.add(currentPage);
                currentPage = new ArrayList();
            }
            currentPageLines += ent.getValue().intValue();
            currentPage.add(ent.getKey());
        }
        boolean bl3 = lastPageNotEmpty = currentPageLines > 0;
        if (lastPageNotEmpty) {
            if (!pages.isEmpty()) {
                this.padPage(currentPage, currentPageLines, false);
            }
            pages.add(currentPage);
        }
        this.pages = pages;
    }

    @Override
    protected Iterable<Text> getLines(int page) throws CommandException {
        int size = this.pages.size();
        if (size == 0) {
            return ImmutableList.of();
        }
        if (page < 1) {
            throw new CommandException(SpongeCommonTranslationHelper.t("Page %s does not exist!", page));
        }
        if (page > size) {
            throw new CommandException(SpongeCommonTranslationHelper.t("Page %s is greater than the max of %s!", page, size));
        }
        return this.pages.get(page - 1);
    }

    @Override
    protected boolean hasPrevious(int page) {
        return page > 1;
    }

    @Override
    protected boolean hasNext(int page) {
        return page < this.pages.size();
    }

    @Override
    protected int getTotalPages() {
        return this.pages.size();
    }
}

