/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.pagination;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandMessageFormatting;
import org.spongepowered.api.command.source.ProxySource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.common.service.pagination.ActivePagination;
import org.spongepowered.common.service.pagination.IterablePagination;
import org.spongepowered.common.service.pagination.ListPagination;
import org.spongepowered.common.service.pagination.PaginationCalculator;
import org.spongepowered.common.service.pagination.SpongePaginationService;

public class SpongePaginationList
implements PaginationList {
    private final SpongePaginationService service;
    private final Iterable<Text> contents;
    private final Optional<Text> title;
    private final Optional<Text> header;
    private final Optional<Text> footer;
    private final Text paginationSpacer;
    private final int linesPerPage;

    public SpongePaginationList(SpongePaginationService service, Iterable<Text> contents, @Nullable Text title, @Nullable Text header, @Nullable Text footer, Text paginationSpacer, int linesPerPage) {
        this.service = service;
        this.contents = contents;
        this.title = Optional.ofNullable(title);
        this.header = Optional.ofNullable(header);
        this.footer = Optional.ofNullable(footer);
        this.paginationSpacer = paginationSpacer;
        this.linesPerPage = linesPerPage;
    }

    @Override
    public Iterable<Text> getContents() {
        return this.contents;
    }

    @Override
    public Optional<Text> getTitle() {
        return this.title;
    }

    @Override
    public Optional<Text> getHeader() {
        return this.header;
    }

    @Override
    public Optional<Text> getFooter() {
        return this.footer;
    }

    @Override
    public Text getPadding() {
        return this.paginationSpacer;
    }

    @Override
    public int getLinesPerPage() {
        return this.linesPerPage;
    }

    @Override
    public void sendTo(MessageReceiver receiver, int page) {
        Supplier<Optional<MessageReceiver>> messageReceiverSupplier;
        Preconditions.checkNotNull(receiver, "The message receiver cannot be null!");
        this.service.registerCommandOnce();
        MessageReceiver realSource = receiver;
        while (realSource instanceof ProxySource) {
            realSource = ((ProxySource)realSource).getOriginalSource();
        }
        PaginationCalculator calculator = new PaginationCalculator(this.linesPerPage);
        Iterable counts = StreamSupport.stream(this.contents.spliterator(), false).map(input -> {
            int lines = calculator.getLines((Text)input);
            return Maps.immutableEntry(input, lines);
        }).collect(Collectors.toList());
        Text title = this.title.orElse(null);
        if (title != null) {
            title = calculator.center(title, this.paginationSpacer);
        }
        if (receiver instanceof Player) {
            UUID playerUuid = ((Player)receiver).getUniqueId();
            messageReceiverSupplier = () -> Sponge.getServer().getPlayer(playerUuid).map(x -> x);
        } else {
            WeakReference<MessageReceiver> srcReference = new WeakReference<MessageReceiver>(receiver);
            messageReceiverSupplier = () -> Optional.ofNullable(srcReference.get());
        }
        ActivePagination pagination = this.contents instanceof List ? new ListPagination(messageReceiverSupplier, calculator, ImmutableList.copyOf(counts), title, this.header.orElse(null), this.footer.orElse(null), this.paginationSpacer) : new IterablePagination(messageReceiverSupplier, calculator, counts, title, this.header.orElse(null), this.footer.orElse(null), this.paginationSpacer);
        this.service.getPaginationState(receiver, true).put(pagination);
        try {
            pagination.specificPage(page);
        }
        catch (CommandException e) {
            receiver.sendMessage(CommandMessageFormatting.error(e.getText()));
        }
    }
}

