/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.permission;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.permission.MemorySubjectData;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectCollection;
import org.spongepowered.api.service.permission.SubjectReference;
import org.spongepowered.common.command.CommandPermissions;
import org.spongepowered.common.service.permission.SpongePermissionService;
import org.spongepowered.common.service.permission.base.GlobalMemorySubjectData;
import org.spongepowered.common.service.permission.base.SpongeSubject;
import org.spongepowered.common.service.permission.base.SpongeSubjectCollection;

public class OpLevelCollection
extends SpongeSubjectCollection {
    private final Map<String, OpLevelSubject> levels;

    public OpLevelCollection(SpongePermissionService service) {
        super("group", service);
        ImmutableMap.Builder<String, OpLevelSubject> build = ImmutableMap.builder();
        for (int i = 0; i <= 4; ++i) {
            build.put("op_" + i, new OpLevelSubject(service, i));
        }
        this.levels = build.build();
    }

    @Override
    public SpongeSubject get(String identifier) {
        SpongeSubject subject = this.levels.get(identifier);
        if (subject == null) {
            throw new IllegalArgumentException(identifier + " is not a valid op level group name (op_{0,4})");
        }
        return subject;
    }

    @Override
    public boolean isRegistered(String identifier) {
        return this.levels.containsKey(identifier);
    }

    @Override
    public Collection<Subject> getLoadedSubjects() {
        return this.levels.values();
    }

    public static class OpLevelSubject
    extends SpongeSubject {
        private final SpongePermissionService service;
        private final int level;
        private final MemorySubjectData data;

        public OpLevelSubject(final SpongePermissionService service, final int level) {
            this.service = service;
            this.level = level;
            this.data = new GlobalMemorySubjectData(service){

                @Override
                public List<SubjectReference> getParents(Set<Context> contexts) {
                    if (!contexts.isEmpty()) {
                        return Collections.emptyList();
                    }
                    if (level == 0) {
                        return super.getParents(contexts);
                    }
                    return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(service.getGroupForOpLevel(level - 1).asSubjectReference())).addAll(super.getParents(contexts))).build();
                }
            };
            CommandPermissions.populateNonCommandPermissions(this.data, (permLevel, name) -> level == permLevel);
        }

        public int getOpLevel() {
            return this.level;
        }

        @Override
        public String getIdentifier() {
            return "op_" + this.level;
        }

        @Override
        public Optional<String> getFriendlyIdentifier() {
            return Optional.empty();
        }

        @Override
        public Optional<CommandSource> getCommandSource() {
            return Optional.empty();
        }

        @Override
        public SubjectCollection getContainingCollection() {
            return this.service.getGroupSubjects();
        }

        @Override
        public PermissionService getService() {
            return this.service;
        }

        @Override
        public SubjectReference asSubjectReference() {
            return this.service.newSubjectReference(this.getContainingCollection().getIdentifier(), this.getIdentifier());
        }

        @Override
        public MemorySubjectData getSubjectData() {
            return this.data;
        }
    }
}

