/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.permission;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.service.permission.PermissionDescription;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.service.permission.SubjectReference;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.common.service.permission.SpongePermissionService;
import org.spongepowered.common.service.permission.base.SpongeSubject;
import org.spongepowered.common.service.permission.base.SpongeSubjectCollection;

class SpongePermissionDescription
implements PermissionDescription {
    private final SpongePermissionService permissionService;
    private final String id;
    @Nullable
    private final Text description;
    private final PluginContainer owner;

    SpongePermissionDescription(SpongePermissionService permissionService, String id, @Nullable Text description, PluginContainer owner) {
        this.permissionService = Preconditions.checkNotNull(permissionService, "permissionService");
        this.id = Preconditions.checkNotNull(id, "id");
        this.description = description;
        this.owner = Preconditions.checkNotNull(owner, "owner");
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Optional<Text> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @Override
    public Map<Subject, Boolean> getAssignedSubjects(String identifier) {
        SpongeSubjectCollection subjects = this.permissionService.get(identifier);
        return subjects.getLoadedWithPermission(this.id);
    }

    @Override
    public CompletableFuture<Map<SubjectReference, Boolean>> findAssignedSubjects(String type) {
        SpongeSubjectCollection subjects = this.permissionService.get(type);
        return subjects.getAllWithPermission(this.id);
    }

    @Override
    public Optional<PluginContainer> getOwner() {
        return Optional.of(this.owner);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpongePermissionDescription other = (SpongePermissionDescription)obj;
        return this.id.equals(other.id) && this.owner.equals(other.owner) && this.description.equals(other.description);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("owner", this.owner).add("id", this.id).toString();
    }

    static class Builder
    implements PermissionDescription.Builder {
        private final SpongePermissionService permissionService;
        private final PluginContainer owner;
        private String id;
        @Nullable
        private Text description;
        private final Map<String, Tristate> roleAssignments = new LinkedHashMap<String, Tristate>();

        Builder(SpongePermissionService permissionService, PluginContainer owner) {
            this.permissionService = Preconditions.checkNotNull(permissionService, "permissionService");
            this.owner = Preconditions.checkNotNull(owner, "owner");
        }

        @Override
        public Builder id(String id) {
            this.id = Preconditions.checkNotNull(id, "permissionId");
            return this;
        }

        @Override
        public Builder description(@Nullable Text description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder assign(String role, boolean value) {
            Preconditions.checkNotNull(role, "role");
            this.roleAssignments.put(role, Tristate.fromBoolean(value));
            return this;
        }

        @Override
        public SpongePermissionDescription register() throws IllegalStateException {
            Preconditions.checkState(this.id != null, "No id set");
            SpongePermissionDescription description = new SpongePermissionDescription(this.permissionService, this.id, this.description, this.owner);
            this.permissionService.addDescription(description);
            SpongeSubjectCollection subjects = this.permissionService.get("role-template");
            for (Map.Entry<String, Tristate> assignment : this.roleAssignments.entrySet()) {
                SpongeSubject subject = subjects.get(assignment.getKey());
                subject.getTransientSubjectData().setPermission(SubjectData.GLOBAL_CONTEXT, this.id, assignment.getValue());
            }
            return description;
        }
    }
}

