/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.sql;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.service.sql.SqlService;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.config.SpongeConfigManager;

@NonnullByDefault
public class SqlServiceImpl
implements SqlService,
Closeable {
    static final Map<String, Properties> PROTOCOL_SPECIFIC_PROPS;
    static final Map<String, BiFunction<PluginContainer, String, String>> PATH_CANONICALIZERS;
    @Nullable
    private LoadingCache<ConnectionInfo, HikariDataSource> connectionCache;

    public SqlServiceImpl() {
        this.buildConnectionCache();
    }

    public void buildConnectionCache() {
        this.connectionCache = null;
        this.connectionCache = CacheBuilder.newBuilder().removalListener(notification -> {
            HikariDataSource source = (HikariDataSource)notification.getValue();
            if (source != null) {
                source.close();
            }
        }).build(new CacheLoader<ConnectionInfo, HikariDataSource>(){

            @Override
            public HikariDataSource load(@Nonnull ConnectionInfo key) throws Exception {
                HikariConfig config = new HikariConfig();
                config.setUsername(key.getUser());
                config.setPassword(key.getPassword());
                config.setDriverClassName(key.getDriverClassName());
                config.setMaximumPoolSize(Runtime.getRuntime().availableProcessors() * 2 + 1);
                config.setLeakDetectionThreshold(60000L);
                Properties driverSpecificProperties = PROTOCOL_SPECIFIC_PROPS.get(key.getDriverClassName());
                if (driverSpecificProperties != null) {
                    config.setDataSourceProperties(driverSpecificProperties);
                }
                config.setJdbcUrl(key.getAuthlessUrl());
                return new HikariDataSource(config);
            }
        });
    }

    @Override
    public DataSource getDataSource(String jdbcConnection) throws SQLException {
        return this.getDataSource(null, jdbcConnection);
    }

    @Override
    public DataSource getDataSource(@Nullable Object plugin, String jdbcConnection) throws SQLException {
        Preconditions.checkNotNull(this.connectionCache);
        jdbcConnection = this.getConnectionUrlFromAlias(jdbcConnection).orElse(jdbcConnection);
        PluginContainer container = null;
        if (plugin != null) {
            container = Sponge.getPluginManager().fromInstance(plugin).orElseThrow(() -> new IllegalArgumentException("The provided plugin object does not have an associated plugin container (in other words, is 'plugin' actually your plugin object?"));
        }
        ConnectionInfo info = ConnectionInfo.fromUrl(container, jdbcConnection);
        try {
            return this.connectionCache.get(info);
        }
        catch (ExecutionException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.connectionCache != null) {
            this.connectionCache.invalidateAll();
        }
    }

    @Override
    public Optional<String> getConnectionUrlFromAlias(String alias) {
        return Optional.ofNullable(SpongeImpl.getGlobalConfigAdapter().getConfig().getSql().getAliases().get(alias));
    }

    static {
        ImmutableMap.Builder<String, Properties> build = ImmutableMap.builder();
        Properties mySqlProps = new Properties();
        mySqlProps.setProperty("useConfigs", "maxPerformance");
        build.put("com.mysql.jdbc.Driver", mySqlProps);
        build.put("org.mariadb.jdbc.Driver", mySqlProps);
        PROTOCOL_SPECIFIC_PROPS = build.build();
        PATH_CANONICALIZERS = ImmutableMap.of("h2", (plugin, orig) -> {
            Path origPath;
            org.h2.engine.ConnectionInfo h2Info = new org.h2.engine.ConnectionInfo((String)orig);
            if (!h2Info.isPersistent() || h2Info.isRemote()) {
                return orig;
            }
            if (orig.startsWith("file:")) {
                orig = orig.substring("file:".length());
            }
            if ((origPath = Paths.get(orig, new String[0])).isAbsolute()) {
                return origPath.toString();
            }
            return SpongeConfigManager.getPrivateRoot(plugin).getDirectory().resolve((String)orig).toAbsolutePath().toString();
        });
    }

    public static class ConnectionInfo {
        private static final Pattern URL_REGEX = Pattern.compile("(?:jdbc:)?([^:]+):(//)?(?:([^:]+)(?::([^@]+))?@)?(.*)");
        private static final String UTF_8 = StandardCharsets.UTF_8.name();
        @Nullable
        private final String user;
        @Nullable
        private final String password;
        private final String driverClassName;
        private final String authlessUrl;
        private final String fullUrl;

        public ConnectionInfo(@Nullable String user, @Nullable String password, String driverClassName, String authlessUrl, String fullUrl) {
            this.user = user;
            this.password = password;
            this.driverClassName = driverClassName;
            this.authlessUrl = authlessUrl;
            this.fullUrl = fullUrl;
        }

        @Nullable
        public String getUser() {
            return this.user;
        }

        @Nullable
        public String getPassword() {
            return this.password;
        }

        public String getDriverClassName() {
            return this.driverClassName;
        }

        public String getAuthlessUrl() {
            return this.authlessUrl;
        }

        public String getFullUrl() {
            return this.fullUrl;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConnectionInfo that = (ConnectionInfo)o;
            return Objects.equal(this.user, that.user) && Objects.equal(this.password, that.password) && Objects.equal(this.driverClassName, that.driverClassName) && Objects.equal(this.authlessUrl, that.authlessUrl) && Objects.equal(this.fullUrl, that.fullUrl);
        }

        public int hashCode() {
            return Objects.hashCode(this.user, this.password, this.driverClassName, this.authlessUrl, this.fullUrl);
        }

        public static ConnectionInfo fromUrl(@Nullable PluginContainer container, String fullUrl) throws SQLException {
            Matcher match = URL_REGEX.matcher(fullUrl);
            if (!match.matches()) {
                throw new IllegalArgumentException("URL " + fullUrl + " is not a valid JDBC URL");
            }
            String protocol = match.group(1);
            boolean hasSlashes = match.group(2) != null;
            String user = ConnectionInfo.urlDecode(match.group(3));
            String pass = ConnectionInfo.urlDecode(match.group(4));
            String serverDatabaseSpecifier = match.group(5);
            BiFunction<PluginContainer, String, String> derelativizer = PATH_CANONICALIZERS.get(protocol);
            if (container != null && derelativizer != null) {
                serverDatabaseSpecifier = derelativizer.apply(container, serverDatabaseSpecifier);
            }
            String unauthedUrl = "jdbc:" + protocol + (hasSlashes ? "://" : ":") + serverDatabaseSpecifier;
            String driverClass = DriverManager.getDriver(unauthedUrl).getClass().getCanonicalName();
            return new ConnectionInfo(user, pass, driverClass, unauthedUrl, fullUrl);
        }

        private static String urlDecode(String str) {
            try {
                return str == null ? null : URLDecoder.decode(str, UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("UTF-8 is not supported on this system", e);
            }
        }
    }
}

