/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.user;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.common.service.user.UserDiscoverer;

public class SpongeUserStorageService
implements UserStorageService {
    public static final UUID FAKEPLAYER_UUID = UUID.fromString("41C82C87-7AfB-4024-BA57-13D2C99CAE77");
    public static final GameProfile FAKEPLAYER_PROFILE = (GameProfile)((Object)new com.mojang.authlib.GameProfile(FAKEPLAYER_UUID, null));

    public void init() {
        UserDiscoverer.init();
    }

    @Override
    public Optional<User> get(UUID uniqueId) {
        try {
            return Optional.ofNullable(UserDiscoverer.findByProfile(Sponge.getServer().getGameProfileManager().get(Preconditions.checkNotNull(uniqueId, "uniqueId")).get()));
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Error looking up GameProfile!", e);
        }
    }

    @Override
    public Optional<User> get(String lastKnownName) {
        Preconditions.checkNotNull(lastKnownName, "lastKnownName");
        Preconditions.checkArgument(lastKnownName.length() > 0 && lastKnownName.length() <= 16, "Invalid username %s", (Object)lastKnownName);
        Preconditions.checkState(Sponge.isServerAvailable(), "Server is not available!");
        return Optional.ofNullable(UserDiscoverer.findByUsername(lastKnownName));
    }

    @Override
    public Optional<User> get(GameProfile profile) {
        return Optional.ofNullable(UserDiscoverer.findByProfile(profile));
    }

    @Override
    public User getOrCreate(GameProfile profile) {
        Optional<User> user;
        if (profile.getUniqueId() == null) {
            String name = profile.getName().orElse(null);
            profile = (GameProfile)((Object)new com.mojang.authlib.GameProfile(FAKEPLAYER_UUID, name));
        }
        if ((user = this.get(profile)).isPresent()) {
            return user.get();
        }
        return UserDiscoverer.create((com.mojang.authlib.GameProfile)((Object)profile));
    }

    public User forceRecreateUser(GameProfile profile) {
        return UserDiscoverer.forceRecreate((com.mojang.authlib.GameProfile)((Object)profile));
    }

    @Override
    public Collection<GameProfile> getAll() {
        return UserDiscoverer.getAllProfiles();
    }

    @Override
    public boolean delete(GameProfile profile) {
        Preconditions.checkState(Sponge.isServerAvailable(), "Server is not available!");
        return UserDiscoverer.delete(Preconditions.checkNotNull(profile, "profile").getUniqueId());
    }

    @Override
    public boolean delete(User user) {
        Preconditions.checkState(Sponge.isServerAvailable(), "Server is not available!");
        return UserDiscoverer.delete(Preconditions.checkNotNull(user, "user").getUniqueId());
    }

    @Override
    public Collection<GameProfile> match(String lastKnownName) {
        lastKnownName = Preconditions.checkNotNull(lastKnownName, "lastKnownName").toLowerCase(Locale.ROOT);
        Collection<GameProfile> allProfiles = UserDiscoverer.getAllProfiles();
        HashSet<GameProfile> matching = Sets.newHashSet();
        for (GameProfile profile : allProfiles) {
            if (!profile.getName().isPresent() || !profile.getName().get().startsWith(lastKnownName)) continue;
            matching.add(profile);
        }
        return matching;
    }
}

