/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.text;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextParseException;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.common.bridge.api.text.TextBridge;
import org.spongepowered.common.bridge.util.text.ITextComponentBridge;

public final class SpongeTexts {
    public static final char COLOR_CHAR = '\u00a7';

    private SpongeTexts() {
    }

    public static Text[] splitChatMessage(ITextComponent component) {
        if (!(component instanceof TextComponentTranslation)) {
            return new Text[]{null, null};
        }
        Text source = null;
        Text body = null;
        for (Object arg : ((TextComponentTranslation)component).func_150271_j()) {
            if (source == null) {
                if (arg instanceof ITextComponent) {
                    source = SpongeTexts.toText((ITextComponent)arg);
                    continue;
                }
                source = Text.of(arg.toString());
                continue;
            }
            Text text = arg instanceof ITextComponent ? SpongeTexts.toText((ITextComponent)arg) : Text.of(arg.toString());
            body = body == null ? text : body.concat(text);
        }
        return new Text[]{source, body};
    }

    public static ITextComponent toComponent(Text text) {
        return ((TextBridge)((Object)text)).bridge$toComponent();
    }

    public static Text toText(ITextComponent component) {
        return ((ITextComponentBridge)component).bridge$toText();
    }

    public static String toPlain(ITextComponent component) {
        return ((ITextComponentBridge)component).bridge$toPlain();
    }

    public static Text fromLegacy(String legacy) {
        return TextSerializers.LEGACY_FORMATTING_CODE.deserialize(legacy);
    }

    public static String toLegacy(Text text) {
        return TextSerializers.LEGACY_FORMATTING_CODE.serialize(text);
    }

    public static String toLegacy(ITextComponent component) {
        return ((ITextComponentBridge)component).bridge$toLegacy('\u00a7');
    }

    public static ITextComponent fixActionBarFormatting(ITextComponent component) {
        if (!component.func_150253_a().isEmpty()) {
            List children = component.func_150253_a();
            for (int i = 0; i < children.size(); ++i) {
                children.set(i, SpongeTexts.fixActionBarFormatting((ITextComponent)children.get(i)));
            }
        }
        TextComponentString result = new TextComponentString(((ITextComponentBridge)component).bridge$getLegacyFormatting());
        result.func_150257_a(component);
        return result;
    }

    public static List<String> asJson(List<Text> list) {
        ArrayList<String> json = Lists.newArrayList();
        for (Text line : list) {
            json.add(TextSerializers.JSON.serialize(line));
        }
        return json;
    }

    public static NBTTagList asJsonNBT(List<Text> list) {
        NBTTagList legacy = new NBTTagList();
        for (Text line : list) {
            legacy.func_74742_a((NBTBase)new NBTTagString(TextSerializers.JSON.serialize(line)));
        }
        return legacy;
    }

    public static List<Text> fromJson(List<String> json) {
        ArrayList<Text> list = Lists.newArrayList();
        for (String line : json) {
            list.add(TextSerializers.JSON.deserialize(line));
        }
        return list;
    }

    public static List<Text> fromNbtJson(NBTTagList legacy) throws TextParseException {
        ArrayList<Text> list = Lists.newArrayList();
        for (int i = 0; i < legacy.func_74745_c(); ++i) {
            list.add(TextSerializers.JSON.deserialize(legacy.func_150307_f(i)));
        }
        return list;
    }

    public static List<Text> fromNbtLegacy(NBTTagList legacy) {
        ArrayList<Text> list = Lists.newArrayList();
        for (int i = 0; i < legacy.func_74745_c(); ++i) {
            list.add(SpongeTexts.fromLegacy(legacy.func_150307_f(i)));
        }
        return list;
    }

    public static NBTTagList asLegacy(List<Text> list) {
        NBTTagList legacy = new NBTTagList();
        for (Text line : list) {
            legacy.func_74742_a((NBTBase)new NBTTagString(SpongeTexts.toLegacy(line)));
        }
        return legacy;
    }
}

