/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.text;

import com.google.common.base.Preconditions;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import org.spongepowered.common.bridge.util.text.ITextComponentBridge;

public class TextComponentIterator
extends UnmodifiableIterator<ITextComponent> {
    private ITextComponentBridge component;
    private Iterator<ITextComponent> children;
    @Nullable
    private Iterator<ITextComponent> currentChildIterator;

    public TextComponentIterator(ITextComponentBridge component) {
        this.component = Preconditions.checkNotNull(component, "component");
    }

    public TextComponentIterator(Iterator<ITextComponent> children) {
        this.children = Preconditions.checkNotNull(children, "children");
        if (this.children.hasNext()) {
            this.setCurrentChildIterator();
        }
    }

    @Override
    public boolean hasNext() {
        return this.component != null || this.currentChildIterator != null && this.currentChildIterator.hasNext();
    }

    @Override
    public ITextComponent next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.component != null) {
            return this.init();
        }
        ITextComponent result = this.currentChildIterator.next();
        if (!this.currentChildIterator.hasNext() && this.children.hasNext()) {
            this.setCurrentChildIterator();
        }
        return result;
    }

    private ITextComponent init() {
        this.children = this.component.bridge$childrenIterator();
        ITextComponent result = (ITextComponent)this.component;
        this.component = null;
        if (this.children.hasNext()) {
            this.setCurrentChildIterator();
        }
        return result;
    }

    private void setCurrentChildIterator() {
        this.currentChildIterator = ((ITextComponentBridge)this.children.next()).bridge$withChildren().iterator();
    }
}

