/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.text.format;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.util.text.TextFormatting;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
public class SpongeTextStyle
extends TextStyle.Base {
    private final TextFormatting handle;

    private SpongeTextStyle(TextFormatting handle, @Nullable Boolean bold, @Nullable Boolean italic, @Nullable Boolean underline, @Nullable Boolean strikethrough, @Nullable Boolean obfuscated) {
        super(bold, italic, underline, strikethrough, obfuscated);
        this.handle = Preconditions.checkNotNull(handle, "handle");
    }

    @Override
    public String getName() {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.handle.name());
    }

    @Override
    public String getId() {
        return "minecraft:" + this.handle.name().toLowerCase(Locale.ENGLISH);
    }

    public static SpongeTextStyle of(TextFormatting handle) {
        if (handle == TextFormatting.RESET) {
            return new SpongeTextStyle(TextFormatting.RESET, false, false, false, false, false);
        }
        return new SpongeTextStyle(handle, SpongeTextStyle.equalsOrNull(handle, TextFormatting.BOLD), SpongeTextStyle.equalsOrNull(handle, TextFormatting.ITALIC), SpongeTextStyle.equalsOrNull(handle, TextFormatting.UNDERLINE), SpongeTextStyle.equalsOrNull(handle, TextFormatting.STRIKETHROUGH), SpongeTextStyle.equalsOrNull(handle, TextFormatting.OBFUSCATED));
    }

    @Nullable
    private static Boolean equalsOrNull(TextFormatting handle, TextFormatting check) {
        return handle == check ? Boolean.valueOf(true) : null;
    }
}

