/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.text.placeholder;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.spongepowered.api.text.placeholder.PlaceholderContext;
import org.spongepowered.api.text.placeholder.PlaceholderParser;
import org.spongepowered.api.text.placeholder.PlaceholderText;
import org.spongepowered.common.text.placeholder.SpongePlaceholderText;

public class SpongePlaceholderTextBuilder
implements PlaceholderText.Builder {
    @Nullable
    private PlaceholderParser parser;
    @Nullable
    private PlaceholderContext context;

    @Override
    public PlaceholderText.Builder setParser(PlaceholderParser parser) {
        this.parser = Preconditions.checkNotNull(parser, "parser cannot be null");
        return this;
    }

    @Override
    public PlaceholderText.Builder setContext(PlaceholderContext context) {
        this.context = Preconditions.checkNotNull(context, "context cannot be null");
        return this;
    }

    @Override
    public PlaceholderText build() throws IllegalStateException {
        if (this.parser == null) {
            throw new IllegalStateException("parser cannot be null");
        }
        if (this.context == null) {
            throw new IllegalStateException("context cannot be null");
        }
        return new SpongePlaceholderText(this.parser, this.context);
    }

    @Override
    public PlaceholderText.Builder from(PlaceholderText value) {
        this.parser = value.getParser();
        this.context = value.getContext();
        return this;
    }

    @Override
    public PlaceholderText.Builder reset() {
        this.context = null;
        this.parser = null;
        return this;
    }
}

