/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.text.selector;

import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3f;
import com.flowpowered.math.vector.Vector3i;
import com.flowpowered.math.vector.Vector3l;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.spongepowered.api.text.selector.ArgumentHolder;
import org.spongepowered.api.text.selector.ArgumentType;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.common.text.selector.SpongeSelectorFactory;

@NonnullByDefault
public class SpongeArgumentHolder<T extends ArgumentHolder<?>>
implements ArgumentHolder<T> {
    private final Set<T> subtypes;

    protected SpongeArgumentHolder() {
        if (!(this instanceof ArgumentType)) {
            throw new IllegalStateException("Must provide subtypes if not ArgumentType");
        }
        this.subtypes = ImmutableSet.of(this);
    }

    public SpongeArgumentHolder(Set<T> subtypes) {
        this.subtypes = ImmutableSet.copyOf(subtypes);
    }

    @Override
    public int getCount() {
        return this.subtypes.size();
    }

    @Override
    public Set<T> getTypes() {
        return this.subtypes;
    }

    public static class SpongeLimit<T extends ArgumentHolder<?>>
    extends SpongeArgumentHolder<T>
    implements ArgumentHolder.Limit<T> {
        private final T min;
        private final T max;

        public SpongeLimit(T min, T max) {
            super(ImmutableSet.of(min, max));
            this.min = min;
            this.max = max;
        }

        @Override
        public T minimum() {
            return this.min;
        }

        @Override
        public T maximum() {
            return this.max;
        }
    }

    public static class SpongeVector3<V, T>
    extends SpongeArgumentHolder<ArgumentType<T>>
    implements ArgumentHolder.Vector3<V, T> {
        private static final SetMultimap<Class<?>, Function<?, ?>> extractFunctionSets = HashMultimap.create();
        private final ArgumentType<T> x;
        private final ArgumentType<T> y;
        private final ArgumentType<T> z;
        private final Set<Function<V, T>> extractFunctionSet;

        public SpongeVector3(ArgumentType<T> x, ArgumentType<T> y, ArgumentType<T> z, Class<V> vectorType) {
            super(ImmutableSet.of(x, y, z));
            this.x = x;
            this.y = y;
            this.z = z;
            this.extractFunctionSet = (Set)extractFunctionSets.get((Object)vectorType);
            if (this.extractFunctionSet.isEmpty()) {
                throw new IllegalStateException("Unknown vector type " + vectorType);
            }
        }

        @Override
        public ArgumentType<T> x() {
            return this.x;
        }

        @Override
        public ArgumentType<T> y() {
            return this.y;
        }

        @Override
        public ArgumentType<T> z() {
            return this.z;
        }

        protected Set<Function<V, T>> extractFunctions() {
            return this.extractFunctionSet;
        }

        static {
            List<Class> vectors = Arrays.asList(Vector3i.class, Vector3l.class, Vector3f.class, Vector3d.class);
            for (Class vec : vectors) {
                LinkedHashSet set = Sets.newLinkedHashSet();
                try {
                    set.add(SpongeSelectorFactory.methodAsFunction(vec.getDeclaredMethod("getX", new Class[0]), false));
                    set.add(SpongeSelectorFactory.methodAsFunction(vec.getDeclaredMethod("getY", new Class[0]), false));
                    set.add(SpongeSelectorFactory.methodAsFunction(vec.getDeclaredMethod("getZ", new Class[0]), false));
                }
                catch (Exception e) {
                    throw new AssertionError((Object)"bad vector3 type");
                }
                extractFunctionSets.putAll(vec, set);
            }
        }
    }
}

