/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.text.selector;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.text.selector.Argument;
import org.spongepowered.api.text.selector.ArgumentType;
import org.spongepowered.api.text.selector.ArgumentTypes;
import org.spongepowered.api.text.selector.Selector;
import org.spongepowered.api.text.selector.SelectorType;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.common.text.selector.SelectorResolver;

@NonnullByDefault
public class SpongeSelector
implements Selector {
    protected final SelectorType type;
    protected final ImmutableMap<ArgumentType<?>, Argument<?>> arguments;
    private final String plain;

    public SpongeSelector(SelectorType type, ImmutableMap<ArgumentType<?>, Argument<?>> arguments) {
        this.type = Preconditions.checkNotNull(type, "type");
        this.arguments = Preconditions.checkNotNull(arguments, "arguments");
        this.plain = this.buildString();
    }

    @Override
    public SelectorType getType() {
        return this.type;
    }

    @Override
    public <T> Optional<T> get(ArgumentType<T> type) {
        Argument<?> argument = this.arguments.get(type);
        return argument != null ? Optional.of(argument.getValue()) : Optional.empty();
    }

    @Override
    public <T> Optional<Argument<T>> getArgument(ArgumentType<T> type) {
        return Optional.ofNullable(this.arguments.get(type));
    }

    @Override
    public <T> Optional<Argument.Invertible<T>> getArgument(ArgumentType.Invertible<T> type) {
        return Optional.ofNullable((Argument.Invertible)this.arguments.get(type));
    }

    @Override
    public List<Argument<?>> getArguments() {
        return ((ImmutableCollection)this.arguments.values()).asList();
    }

    @Override
    public boolean has(ArgumentType<?> type) {
        return this.arguments.containsKey(type);
    }

    @Override
    public boolean isInverted(ArgumentType.Invertible<?> type) {
        if (!this.has(type)) {
            return false;
        }
        return ((Argument.Invertible)this.arguments.get(type)).isInverted();
    }

    public ImmutableSet<Entity> resolve(CommandSource origin) {
        return new SelectorResolver((Selector)this, origin).resolve();
    }

    public ImmutableSet<Entity> resolve(Extent ... extents) {
        return this.resolve(ImmutableSet.copyOf(extents));
    }

    public ImmutableSet<Entity> resolve(Collection<? extends Extent> extents) {
        return new SelectorResolver((Selector)this, extents).resolve();
    }

    public ImmutableSet<Entity> resolve(Location<World> location) {
        Selector.Builder selector = (Selector.Builder)Selector.builder().from(this);
        if (!this.has(ArgumentTypes.POSITION.x())) {
            selector.add(ArgumentTypes.POSITION.x(), location.getPosition().getFloorX());
        }
        if (!this.has(ArgumentTypes.POSITION.y())) {
            selector.add(ArgumentTypes.POSITION.y(), location.getPosition().getFloorY());
        }
        if (!this.has(ArgumentTypes.POSITION.z())) {
            selector.add(ArgumentTypes.POSITION.z(), location.getPosition().getFloorZ());
        }
        return new SelectorResolver(selector.build(), ImmutableSet.of(location.getExtent())).resolve();
    }

    @Override
    public String toPlain() {
        return this.plain;
    }

    @Override
    public Selector.Builder toBuilder() {
        return (Selector.Builder)Selector.builder().from(this);
    }

    private String buildString() {
        StringBuilder result = new StringBuilder();
        result.append('@').append(this.type.getName());
        if (!this.arguments.isEmpty()) {
            Collection args = this.arguments.values();
            result.append(args.stream().map(Argument::toPlain).collect(Collectors.joining(",", "[", "]")));
        }
        return result.toString();
    }
}

