/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.text.selector;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.spongepowered.api.text.selector.Argument;
import org.spongepowered.api.text.selector.ArgumentType;
import org.spongepowered.api.text.selector.Selector;
import org.spongepowered.api.text.selector.SelectorType;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.common.text.selector.SpongeArgument;
import org.spongepowered.common.text.selector.SpongeSelector;

@NonnullByDefault
public class SpongeSelectorBuilder
implements Selector.Builder {
    @Nullable
    private SelectorType type;
    private Map<ArgumentType<?>, Argument<?>> arguments = new LinkedHashMap();

    @Override
    public Selector.Builder type(SelectorType type) {
        this.type = Preconditions.checkNotNull(type, "type");
        return this;
    }

    @Override
    public Selector.Builder add(Argument<?> ... arguments) {
        for (Argument<?> argument : Preconditions.checkNotNull(arguments, "arguments")) {
            Preconditions.checkNotNull(argument, "argument");
            this.arguments.put(argument.getType(), argument);
        }
        return this;
    }

    @Override
    public Selector.Builder add(Iterable<Argument<?>> arguments) {
        for (Argument<?> argument : Preconditions.checkNotNull(arguments, "arguments")) {
            Preconditions.checkNotNull(argument, "argument");
            this.arguments.put(argument.getType(), argument);
        }
        return this;
    }

    @Override
    public <T> Selector.Builder add(ArgumentType<T> type, T value) {
        this.arguments.put(type, new SpongeArgument<T>(type, value));
        return this;
    }

    @Override
    public Selector.Builder remove(Argument<?> ... arguments) {
        for (Argument<?> argument : Preconditions.checkNotNull(arguments, "arguments")) {
            Preconditions.checkNotNull(argument, "argument");
            this.arguments.remove(argument.getType());
        }
        return this;
    }

    @Override
    public Selector.Builder remove(Iterable<Argument<?>> arguments) {
        for (Argument<?> argument : Preconditions.checkNotNull(arguments, "arguments")) {
            Preconditions.checkNotNull(argument, "argument");
            this.arguments.remove(argument.getType());
        }
        return this;
    }

    @Override
    public Selector.Builder remove(ArgumentType<?> ... types) {
        for (ArgumentType<?> type : Preconditions.checkNotNull(types, "types")) {
            Preconditions.checkNotNull(type, "type");
            this.arguments.remove(type);
        }
        return this;
    }

    @Override
    public Selector build() {
        return new SpongeSelector(this.type, ImmutableMap.copyOf(this.arguments));
    }

    @Override
    public Selector.Builder from(Selector selector) {
        this.type = selector.getType();
        this.arguments = new LinkedHashMap(((SpongeSelector)selector).arguments);
        return this;
    }

    @Override
    public Selector.Builder reset() {
        this.type = null;
        this.arguments = new LinkedHashMap();
        return this;
    }
}

