/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.text.selector;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.scoreboard.Score;
import org.spongepowered.api.text.selector.Argument;
import org.spongepowered.api.text.selector.ArgumentHolder;
import org.spongepowered.api.text.selector.ArgumentType;
import org.spongepowered.api.text.selector.ArgumentTypes;
import org.spongepowered.api.text.selector.Selector;
import org.spongepowered.api.text.selector.SelectorFactory;
import org.spongepowered.api.text.selector.SelectorType;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.mixin.core.command.EntitySelectorAccessor;
import org.spongepowered.common.text.selector.SpongeArgument;
import org.spongepowered.common.text.selector.SpongeArgumentHolder;
import org.spongepowered.common.text.selector.SpongeArgumentType;
import org.spongepowered.common.text.selector.SpongeSelector;
import org.spongepowered.common.text.selector.SpongeSelectorBuilder;

@NonnullByDefault
public class SpongeSelectorFactory
implements SelectorFactory {
    public static final SpongeSelectorFactory INSTANCE = new SpongeSelectorFactory();
    private static final Map<String, SelectorType> idToType;
    private final Map<String, ArgumentHolder.Limit<ArgumentType<Integer>>> scoreToTypeMap = Maps.newLinkedHashMap();
    private final Map<String, ArgumentType<?>> argumentLookupMap = Maps.newLinkedHashMap();

    private SpongeSelectorFactory() {
    }

    public static <K, V> Function<K, V> methodAsFunction(Method m, boolean isStatic) {
        if (isStatic) {
            return input -> {
                try {
                    return m.invoke(null, input);
                }
                catch (IllegalAccessException e) {
                    SpongeImpl.getLogger().debug(m + " wasn't public", (Throwable)e);
                    return null;
                }
                catch (IllegalArgumentException e) {
                    SpongeImpl.getLogger().debug(m + " failed with paramter " + input, (Throwable)e);
                    return null;
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e.getCause());
                }
            };
        }
        return input -> {
            try {
                return m.invoke(input, new Object[0]);
            }
            catch (IllegalAccessException e) {
                SpongeImpl.getLogger().debug(m + " wasn't public", (Throwable)e);
                return null;
            }
            catch (IllegalArgumentException e) {
                SpongeImpl.getLogger().debug(m + " failed with paramter " + input, (Throwable)e);
                return null;
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        };
    }

    @Override
    public Selector.Builder createBuilder() {
        return new SpongeSelectorBuilder();
    }

    @Override
    public Selector parseRawSelector(String selector) {
        Preconditions.checkArgument(selector.startsWith("@"), "Invalid selector %s", (Object)selector);
        int argListIndex = selector.indexOf(91);
        if (argListIndex < 0) {
            argListIndex = selector.length();
        } else {
            int end = selector.indexOf(93);
            Preconditions.checkArgument(end > argListIndex && selector.charAt(end - 1) != ',', "Invalid selector %s", (Object)selector);
        }
        String typeStr = selector.substring(1, argListIndex);
        Preconditions.checkArgument(idToType.containsKey(typeStr), "No type known as '%s'", (Object)typeStr);
        SelectorType type = idToType.get(typeStr);
        try {
            Map<String, String> rawMap = argListIndex == selector.length() ? ImmutableMap.of() : EntitySelectorAccessor.accessor$getArgumentMap(selector.substring(argListIndex + 1, selector.length() - 1));
            Map<ArgumentType<?>, Argument<?>> arguments = this.parseArguments(rawMap);
            return new SpongeSelector(type, ImmutableMap.copyOf(arguments));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid selector " + selector, e);
        }
    }

    @Override
    public ArgumentHolder.Limit<ArgumentType<Integer>> createScoreArgumentType(String name) {
        if (!this.scoreToTypeMap.containsKey(name)) {
            SpongeArgumentType<Integer> min = this.createArgumentType("score_" + name + "_min", Integer.class, Score.class.getName());
            SpongeArgumentType<Integer> max = this.createArgumentType("score_" + name, Integer.class, Score.class.getName());
            this.scoreToTypeMap.put(name, new SpongeArgumentHolder.SpongeLimit<SpongeArgumentType<Integer>>(min, max));
        }
        return this.scoreToTypeMap.get(name);
    }

    @Override
    public Optional<ArgumentType<?>> getArgumentType(String name) {
        if (name.startsWith("score_")) {
            String objective = name.replaceAll("^score_", "").replaceAll("_min$", "");
            ArgumentHolder.Limit<ArgumentType<Integer>> limit = this.createScoreArgumentType(objective);
            if (name.endsWith("_min")) {
                return Optional.of(limit.minimum());
            }
            return Optional.of(limit.maximum());
        }
        return Optional.ofNullable(this.argumentLookupMap.get(name));
    }

    @Override
    public Collection<ArgumentType<?>> getArgumentTypes() {
        return this.argumentLookupMap.values();
    }

    public SpongeArgumentType<String> createArgumentType(String key) {
        return this.createArgumentType(key, String.class);
    }

    public <T> SpongeArgumentType<T> createArgumentType(String key, Class<T> type) {
        return this.createArgumentType(key, type, type.getName());
    }

    public <T> SpongeArgumentType<T> createArgumentType(String key, Class<T> type, String converterKey) {
        if (!this.argumentLookupMap.containsKey(key)) {
            Preconditions.checkNotNull(converterKey, "converter key cannot be null");
            this.argumentLookupMap.put(key, new SpongeArgumentType<T>(key, type, converterKey));
        }
        return (SpongeArgumentType)this.argumentLookupMap.get(key);
    }

    public <T> SpongeArgumentType.Invertible<T> createInvertibleArgumentType(String key, Class<T> type) {
        return this.createInvertibleArgumentType(key, type, type.getName());
    }

    public <T> SpongeArgumentType.Invertible<T> createInvertibleArgumentType(String key, Class<T> type, String converterKey) {
        if (!this.argumentLookupMap.containsKey(key)) {
            Preconditions.checkNotNull(converterKey, "converter key cannot be null");
            this.argumentLookupMap.put(key, new SpongeArgumentType.Invertible<T>(key, type, converterKey));
        }
        return (SpongeArgumentType.Invertible)this.argumentLookupMap.get(key);
    }

    @Override
    public <T> Argument<T> createArgument(ArgumentType<T> type, T value) {
        if (type instanceof ArgumentType.Invertible) {
            return this.createArgument((ArgumentType.Invertible)type, value, false);
        }
        return new SpongeArgument<T>(type, value);
    }

    @Override
    public <T> Argument.Invertible<T> createArgument(ArgumentType.Invertible<T> type, T value, boolean inverted) {
        return new SpongeArgument.Invertible<T>(type, value, inverted);
    }

    @Override
    public <T, V> Set<Argument<T>> createArguments(ArgumentHolder<? extends ArgumentType<T>> type, V value) {
        LinkedHashSet<Argument<T>> set = Sets.newLinkedHashSet();
        if (type instanceof SpongeArgumentHolder.SpongeVector3) {
            Set extractors = ((SpongeArgumentHolder.SpongeVector3)type).extractFunctions();
            Set<ArgumentType<T>> types = type.getTypes();
            Iterator extIter = extractors.iterator();
            Iterator<ArgumentType<T>> typeIter = types.iterator();
            while (extIter.hasNext() && typeIter.hasNext()) {
                Function extractor = extIter.next();
                ArgumentType<T> subtype = typeIter.next();
                set.add(this.createArgument(subtype, extractor.apply(value)));
            }
        }
        return set;
    }

    @Override
    public Argument<?> parseArgument(String argument) throws IllegalArgumentException {
        String[] argBits = argument.split("=");
        SpongeArgumentType<Object> type = this.getArgumentTypeWithChecks(argBits[0]);
        String value = argBits[1];
        return this.parseArgumentCreateShared(type, value);
    }

    public Map<ArgumentType<?>, Argument<?>> parseArguments(Map<String, String> argumentMap) {
        HashMap generated = new HashMap(argumentMap.size());
        for (Map.Entry<String, String> argument : argumentMap.entrySet()) {
            String argKey = argument.getKey();
            SpongeArgumentType<Object> type = this.getArgumentTypeWithChecks(argKey);
            String value = argument.getValue();
            generated.put(type, this.parseArgumentCreateShared(type, value));
        }
        return generated;
    }

    private SpongeArgumentType<Object> getArgumentTypeWithChecks(String argKey) {
        Optional<ArgumentType<?>> type = ArgumentTypes.valueOf(argKey);
        if (!type.isPresent()) {
            throw new IllegalArgumentException("Invalid argument key " + argKey);
        }
        ArgumentType<?> unwrappedType = type.get();
        if (!(unwrappedType instanceof SpongeArgumentType)) {
            throw new IllegalStateException("Cannot convert from string: " + unwrappedType);
        }
        return (SpongeArgumentType)unwrappedType;
    }

    private Argument<?> parseArgumentCreateShared(SpongeArgumentType<Object> type, String value) {
        Argument<Object> created = type instanceof ArgumentType.Invertible && !value.isEmpty() && value.charAt(0) == '!' ? this.createArgument((ArgumentType.Invertible)((Object)type), type.convert(value.substring(1)), true) : this.createArgument(type, type.convert(value));
        return created;
    }

    @Override
    public List<String> complete(String selector) {
        Stream<String> choices;
        if (!selector.startsWith("@") || selector.contains("]")) {
            return ImmutableList.of();
        }
        if (!selector.contains("[")) {
            choices = Sponge.getRegistry().getAllOf(SelectorType.class).stream().map(type -> "@" + type.getId());
        } else {
            int keyStart = Math.max(selector.indexOf("["), selector.lastIndexOf(",")) + 1;
            int valueStart = selector.lastIndexOf("=") + 1;
            String prefix = selector.substring(Math.max(keyStart, valueStart));
            if (keyStart <= valueStart) {
                Optional<ArgumentType<?>> type2 = ArgumentTypes.valueOf(selector.substring(keyStart, valueStart - 1));
                if (!type2.isPresent()) {
                    return ImmutableList.of();
                }
                return ImmutableList.of();
            }
            choices = ArgumentTypes.values().stream().map(ArgumentType::getKey);
            choices = choices.map(input -> prefix + input);
        }
        return choices.filter(choice -> choice.startsWith(selector)).collect(ImmutableList.toImmutableList());
    }

    static {
        ImmutableMap.Builder<String, SelectorType> builder = ImmutableMap.builder();
        for (SelectorType type : Sponge.getRegistry().getAllOf(SelectorType.class)) {
            builder.put(type.getName(), type);
        }
        idToType = builder.build();
    }
}

