/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.api.data.type.DyeColor;
import org.spongepowered.api.util.Color;
import org.spongepowered.common.mixin.core.entity.passive.EntitySheepAccessor;

public final class ColorUtil {
    public static Optional<Color> getItemStackColor(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemArmor) {
            NBTTagCompound tagCompound = stack.func_77978_p();
            if (tagCompound == null || !tagCompound.func_74764_b("display")) {
                return Optional.empty();
            }
            int color = ((ItemArmor)item).func_82814_b(stack);
            return color == -1 ? Optional.empty() : Optional.of(Color.ofRgb(color));
        }
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            return Optional.empty();
        }
        if (!compound.func_74764_b("color")) {
            return Optional.empty();
        }
        return Optional.of(Color.ofRgb(compound.func_74762_e("color")));
    }

    public static int javaColorToMojangColor(Color color) {
        Preconditions.checkNotNull(color);
        return ((color.getRed() << 8) + color.getGreen() << 8) + color.getBlue();
    }

    public static int dyeColorToMojangColor(DyeColor dyeColor) {
        float[] dyeRgbArray = EntitySheepAccessor.accessor$createSheepColor(EnumDyeColor.valueOf((String)dyeColor.getName().toUpperCase(Locale.ENGLISH)));
        int trueRed = (int)(dyeRgbArray[0] * 255.0f);
        int trueGreen = (int)(dyeRgbArray[1] * 255.0f);
        int trueBlue = (int)(dyeRgbArray[2] * 255.0f);
        int combinedRg = (trueRed << 8) + trueGreen;
        int actualColor = (combinedRg << 8) + trueBlue;
        return actualColor;
    }

    public static Color fromDyeColor(DyeColor dyeColor) {
        float[] dyeRgbArray = EntitySheepAccessor.accessor$createSheepColor(EnumDyeColor.valueOf((String)dyeColor.getName().toUpperCase(Locale.ENGLISH)));
        int trueRed = (int)(dyeRgbArray[0] * 255.0f);
        int trueGreen = (int)(dyeRgbArray[1] * 255.0f);
        int trueBlue = (int)(dyeRgbArray[2] * 255.0f);
        return Color.ofRgb(trueRed, trueGreen, trueBlue);
    }

    public static EnumDyeColor fromColor(Color color) {
        for (EnumDyeColor enumDyeColor : EnumDyeColor.values()) {
            Color color1 = ColorUtil.fromDyeColor((DyeColor)enumDyeColor);
            if (!color.equals(color1)) continue;
            return enumDyeColor;
        }
        return EnumDyeColor.WHITE;
    }

    public static void setItemStackColor(ItemStack stack, Color value) {
        int mojangColor = ColorUtil.javaColorToMojangColor(value);
        stack.func_190925_c("display").func_74768_a("color", mojangColor);
    }

    public static boolean hasColorInNbt(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("display") && stack.func_77978_p().func_74775_l("display").func_74764_b("color");
    }

    public static boolean hasColor(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item instanceof ItemArmor && ((ItemArmor)item).func_82812_d() == ItemArmor.ArmorMaterial.LEATHER;
    }

    private ColorUtil() {
    }
}

