/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.LocaleUtils;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.common.SpongeImpl;

@NonnullByDefault
public final class LocaleCache {
    private static final Map<String, Locale> LOCALE_CACHE = Maps.newHashMap();
    private static final Function<String, Locale> LOCALE_FUNCTION = new Function<String, Locale>(){

        @Override
        public Locale apply(String key) {
            try {
                return LocaleUtils.toLocale(key);
            }
            catch (IllegalArgumentException ignored) {
                String fixedKey = this.fixLocaleKey(key);
                try {
                    return LocaleUtils.toLocale(fixedKey);
                }
                catch (IllegalArgumentException e) {
                    SpongeImpl.getLogger().error("Could not transform '{}' or '{}' into a Locale", (Object)key, (Object)fixedKey);
                    throw e;
                }
            }
        }

        private String fixLocaleKey(String key) {
            String[] parts = key.split("_");
            if (parts.length == 2) {
                return parts[0] + '_' + parts[1].toUpperCase();
            }
            return key;
        }
    };

    private LocaleCache() {
    }

    public static Locale getLocale(String tag) {
        return LOCALE_CACHE.computeIfAbsent(tag, LOCALE_FUNCTION);
    }

    public static void preload(Locale locale) {
        String tag = locale.toString();
        LOCALE_CACHE.put(tag, locale);
        LOCALE_CACHE.put(tag.toLowerCase(), locale);
    }
}

